% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gra_de2_patt.R
\name{gra_de2_patt}
\alias{gra_de2_patt}
\title{Values to patterns}
\usage{
gra_de2_patt(vaEU, vaMS, vaTime)
}
\arguments{
\item{vaEU}{EU values sorted in ascending order by time.}

\item{vaMS}{member state values  sorted in ascending order by time.}

\item{vaTime}{sorted pair of times.}
}
\value{
a number referring to  pattern whose label depends on the
         indicator type
}
\description{
Gradients values and Delta2 are mapped to one pattern (string and number).
 See Eurofound 2018 report.
 In the mapping table within this function
 +1 means greater than zero, 0 means equal to zero,
 -1 means smaller than 0.
 For column EU_vs_MS,
 if  graEU > graMS then  EU_vs_MS = +1;
 if  graEU < graMS then  EU_vs_MS = -1;
 if  graEU == graMS then  EU_vs_MS = 0.
 Code NA is left to indicate not relevant features.
 Further codes are added here from 13 to 18 for parallelism;
 codes 19 and 20 are for crossed lines joining the EU pair and the MS pair.
 Code 21 stands for "to be visually inspected".
}
\examples{

# Example 1
vaEU <- c(5,7)
vaMS <- c(6,8)
vaTime <- c(1999,2000)
resG1 <- gra_de2_patt(vaEU,vaMS,vaTime)

# Example 2:
vaEU <- c(7,2)
vaMS <- c(9,4)
vaTime <- c(2009,2010)
resG2 <- gra_de2_patt(vaEU,vaMS,vaTime)

# Example 3:
vaTime <- c(2009,2010)
vaEU <- c(100 , 120)
vaMS <- c( 50, 90)
resG3 <- gra_de2_patt(vaEU,vaMS,vaTime)

}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
