% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_indicator_EIGE.R
\name{extract_indicator_EIGE}
\alias{extract_indicator_EIGE}
\title{Create a dataset (tibble) for an EIGE indicator.}
\usage{
extract_indicator_EIGE(
  indicator_code,
  fromTime,
  toTime,
  countries = convergEU_glb()$EU27$memberStates$codeMS,
  type_flag = FALSE
)
}
\arguments{
\item{indicator_code}{one of the following strings:"INDEX",  "WORK",
"MONEY", "KNOWLEDGE",  "TIME", "POWER",
"HEALTH",  "FTE", "DWL", "SEGRE", "INCOME",
 "TERTIARY", "CARE", "HOUSE",  "MINISTER",
  "PARLIAMENT", "BOARD", "HLY","METADATA"}

\item{fromTime}{first year to be considered}

\item{toTime}{last year to be considered}

\item{countries}{a collection of strings representing countries
in the standard two letters format}

\item{type_flag}{if FALSE data are returned, otherwise the type of indicator
is returned; if METADATA is selected, NA is returned}
}
\value{
a dataset (tibble) years by countries
}
\description{
From the EIGE database, a dataset is created whose structure is
years by countries.
}
\details{
If the indicator_code is equal to "METADATA" then information on
available indicators is provided as a dataframe (tibble):
names of indicators are contained in the variable "Worksheet name".
}
\examples{


# Extract metadata:
myTB1 <- extract_indicator_EIGE(
    indicator_code = "METADATA" #Code_in_database
    )

# Extract indicator "HOUSE" from 2010 to 2015:
myTB2 <- extract_indicator_EIGE(
    indicator_code = "HOUSE", #Code_in_database
    fromTime=2010,
    toTime=2015)



}
