% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_indicator_ECG.R
\name{extract_indicator_ECG}
\alias{extract_indicator_ECG}
\title{Create a dataset (tibble) for an ECG indicator.}
\usage{
extract_indicator_ECG(
  indicator_code,
  fromTime,
  toTime,
  countries = convergEU_glb()$EU27$memberStates$codeMS,
  type_flag = FALSE
)
}
\arguments{
\item{indicator_code}{one of the following strings:"dataset2", "demo_magec_AND_demo_pjan"}

\item{fromTime}{first year to be considered}

\item{toTime}{last year to be considered}

\item{countries}{a collection of strings representing countries
in the standard two letters format}

\item{type_flag}{if FALSE data are returned, otherwise the type of indicator
is returned; if METADATA_ECG is selected, NA is returned}
}
\value{
a dataset (tibble) years by countries
}
\description{
From the ECG database, a dataset is created whose structure is
years by countries.
}
\details{
If the indicator_code is equal to "METADATA_ECG" then information on
available indicators is provided as a dataframe (tibble):
names of indicators are contained in the variable "Worksheet name".
}
\examples{


# Extract metadata:
myTB1 <- extract_indicator_ECG(
    indicator_code = "METADATA_ECG" #Code_in_database
    )

# Extract indicator "dataset2" from 2010 to 2021:
myTB2 <- extract_indicator_ECG(
    indicator_code = "dataset2", #Code_in_database
    fromTime=2010,
    toTime=2021)



}
