% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_conv.R
\name{sigma_conv}
\alias{sigma_conv}
\title{Sigma-convergence statistic}
\usage{
sigma_conv(tavDes, timeName = "time", time_0 = NA, time_t = NA)
}
\arguments{
\item{tavDes}{the dataframe time by countries.}

\item{timeName}{the name of the variable that contains time information.}

\item{time_0}{starting time to consider; if NA all times considered.}

\item{time_t}{last time to consider; if NA all times considered.}
}
\value{
a tibble with the value of sigma convergence (called stdDev or CV)
          along time, where the original *timeName* is preserved.
}
\description{
Given a dataframe of quantitative indicators along time,
the sigma convergence is a statistic capturing some convergence features.
A time variable must be present whether sorted or not.
Missing values are not allowed.
Here it is calculated at each observed time.
All countries belonging to the reference mean must be included into the
dataset.
}
\examples{

# Example 1
# Dataframe in the format time by countries:
require(tibble)
myTB  <- tibble::tribble(
    ~years, ~UK, ~DE, ~IT,
    1990,   998,  1250, 332,
    1988,   1201, 868, 578,
    1989,   1150, 978, 682
    )
reSigConv <- sigma_conv(myTB,timeName="years")

# Results for the sigma convergence:
reSigConv$res

# Example 2
# Sigma convergence, scrambled time, different name, subset of times:
myTB1  <- tibble::tribble(
    ~years, ~UK, ~DE, ~IT,
    1990,   998,  1250, 332,
    1988,   1201, 868, 578,
    1989,   1150, 978, 682,
    1991,   232, 225, 227,
    1987,   122, 212, 154
    )
reSigConv1 <- sigma_conv(myTB1,timeName="years", time_0 = 1988,time_t = 1990)

# Example 3
# Sigma convergence for the emp_20_64_MS Eurofound dataset:
data("emp_20_64_MS")
reSigConv2 <- sigma_conv(emp_20_64_MS)
reSigConv3 <- sigma_conv(emp_20_64_MS, timeName = "time", time_0 = 2002,time_t = 2004)
reSigConv4 <- sigma_conv(emp_20_64_MS, timeName = "time", time_0 = 2002,time_t = 2016)

}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
