% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_var.R
\name{pop_var}
\alias{pop_var}
\title{Population variance and standard deviation}
\usage{
pop_var(veval)
}
\arguments{
\item{veval}{vector of data.}
}
\value{
the variance and standard deviation
}
\description{
The denominator in n instead of n-1, like in the R base function.
Note that missing values are deleted by default.
}
\details{
Note that the second argument, if assigned,  causes only one summary
of object returned.
}
\examples{


myvec<-c(5,2,3,NA,4)
pop_var(myvec)

vec1<-c(10, 20, 15,60,32)
pop_var(vec1)

vec2<-c(NA,NA, 13, 19, 20)
pop_var(vec2)

vec4<-c(seq(from = 5, to = 100, by = 5))
pop_var(vec4)

}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
