% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_contrast.R
\name{use_contrasts.function}
\alias{use_contrasts.function}
\title{Function method for use_contrasts}
\usage{
\method{use_contrasts}{`function`}(
  factor_col,
  code_by = NA,
  reference_level = NA,
  set_intercept = NA,
  drop_trends = NA,
  labels = NULL,
  as_is = FALSE,
  ...
)
}
\arguments{
\item{factor_col}{A factor vector, eg from df$factorVarName}

\item{code_by}{A function to be called, should return a contrast matrix}

\item{reference_level}{The name of the level to use as the reference level,
default NA}

\item{set_intercept}{The intercept to use, default NA}

\item{drop_trends}{The trends to drop, default NA}

\item{labels}{A vector of labels to apply to the matrix column names, default}

\item{as_is}{Logical, default FALSE, whether to leave the resulting matrix}

\item{...}{Additional arguments to be passed to \code{code_by()}}
}
\value{
A contrast coding matrix with labels and proper reference level
}
\description{
If the user provides a function, use the function and supplied arguments to
create a contrast matrix
}
\examples{
use_contrasts(gl(5,1), sum_code)
}
