% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{two_factor_incompl}
\alias{two_factor_incompl}
\title{Incomplete Two-Factor Experiment with Repeated Measurments}
\value{
\item{two_factor_incompl}{A data frame}
}
\description{
Incomplete Two-Factor Experiment with Repeated Measurments
}
\details{
In a gene expression experiment, stem cells were differentiated using a set
of factors (such as media types, cell spreads etc.). These factors were
collapsed into a single cell environment configurations variable. The cell
lines were assays over three days. Two of the configurations were only run
on the first day and the other two were assays at baseline.

To get the materials, three donors provided materials. These donors
provided (almost) equal replication across the two experimental factors (day
and configuration).

One of the goals of this experiment was to assess pre-specified
differences in the configuration at each time point. For example, the
differences between configurations \code{A} and \code{B} at day one is of interest.
Also, the differences between configurations \code{C} and \code{D} at each time points
were important.

Since there are missing cells in the design, it is not a complete two-way
factorial. One way to analyze this experiment is to further collapse the
time and configuration data into a single variable and then specify each
comparison using this factor.
}
\examples{
two_factor_incompl
}
\keyword{datasets}
