% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_2x2_table_tests.R
\name{the_2x2_table_tests}
\alias{the_2x2_table_tests}
\title{The 2x2 table tests}
\usage{
the_2x2_table_tests(n, gamma = 1e-04)
}
\arguments{
\item{n}{frequency matrix}

\item{gamma}{parameter for the Berger and Boos procedure}
}
\value{
NULL. This function should be called for its printed output
}
\description{
Wrapper for \verb{_test_2x2} functions on Chapter 4.
}
\section{Table orientation}{
 In most study designs, rows designate a grouping of the data, for
instance, into treatment or exposure groups, while the columns indicate a
dichotomous outcome, usually with the first column representing the outcome
of interest. This designation of rows and columns may not be relevant in all
study designs, please see the introduction to chapter 4 for details.
}

\examples{
# Example: A lady tasting a cup of tea
the_2x2_table_tests(tea)

# Example: Lampasona et al. (2013)
the_2x2_table_tests(lampasona_2013)

\dontrun{
  the_2x2_table_tests(perondi_2004) # Example: Perondi et al. (2004)
  the_2x2_table_tests(ritland_2007) # Example: Ritland et al. (2007)
}
}
