% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_intervals}
\alias{plot_intervals}
\title{Plot intervals}
\usage{
plot_intervals(intervals, estimates = NULL, interval_value_labels = FALSE,
  estimate_value_labels = FALSE, interval_labels_offset,
  estimate_labels_offset, interval_type = "norm",
  plot_estimate_marks = FALSE, estimate_mark_points = c(1.2 *
  graphics::strheight("M"), 0.05, -1.2 * graphics::strheight("M"), -0.05), ...)
}
\arguments{
\item{intervals}{The interval(s) to be plotted. Two column matrix.}

\item{estimates}{Estimates for each of the intervals (optional).}

\item{interval_value_labels}{Logical value specifying whether interval value labels are to be added.}

\item{estimate_value_labels}{Logical value specifying whether estimate value labels are to be added.}

\item{interval_labels_offset}{Amount to offset interval labels by from the centre of the end
of the interval's plot. \code{c(x1, x2, y1, y2)}.}

\item{estimate_labels_offset}{Amount to offset estimate labels by. \code{c(x, y)}. Normally want the
estimate to be x-located at its value, but may want a y-offset to move it
above or below the plot shape that represents the interval.}

\item{interval_type}{Set the way the interval is presented. Current options are
\code{c("norm", "unif")} for a normal distribution-based curve
and a box, respectively.}

\item{plot_estimate_marks}{Whether to plot marks at the x location of the estimates.}

\item{estimate_mark_points}{y positions of the ends of the estimate marks as a numeric vector of length
4. Values are, in order: start (relative to centre), end (relative to box
top), start (relative to centre), end (relative to box bottom).}

\item{...}{Further parameters to be passed on.}
}
\description{
Plot intervals on a canvas, typically prepared with
\code{plot_region_canvas()}.
}
\details{
The \code{estimate_mark_points} parameter can be used to set the length of
estimate marks, if they are requested using
\code{plot_estimate_marks = TRUE}. The default is extending a little above
and below the interval plot shape and with a gap in the middle big enough
for a line of text (a bit bigger than the height of letter "M"). To leave
no gap, set the first and third elements to zero, e.g.
\code{estimate_mark_points = c(0, 0.05, 0, -0.05)}. To have the marks not
extend outside of the interval shape, set the second and fourth elements to
zero, e.g. \code{estimate_mark_points = c(0, 0, 0, 0)}.
}
