% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_staff_member_page.R
\name{create_staff_member_page}
\alias{create_staff_member_page}
\title{Create a quarto file for a specific staff member}
\usage{
create_staff_member_page(staff_member, site_dir, staff_folder = "staff")
}
\arguments{
\item{staff_member}{An object of class \code{staff_member} that will be used to
generate the template.}

\item{site_dir}{Directory of the website.}

\item{staff_folder}{Subfolder in which the staff qmd files are stored.
Default "staff". Note that each template will be \code{index.qmd} to facilitate
pretty link formatting in-browser.}
}
\value{
No return value, called to create a qmd file for the staff member.
}
\description{
Creates a quarto file for a given input staff member.
}
\examples{
example_staff_member <- staff_member(
    id = "example-id",
    name = "Example Name",
    description = "Example description for example staff member.",
    external_link = "http://www.example.com/",
    internal_link = FALSE
)
create_staff_member_page(example_staff_member, tempdir())

}
