% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matexp.R
\name{matexp}
\alias{matexp}
\title{Matrix Exponential}
\usage{
matexp(A, ...)
}
\arguments{
\item{A}{a square matrix, real or complex.}

\item{...}{arguments passed to or from other methods.}
}
\value{
The matrix exponential of A. Method used may be chosen from the options available in \code{expm}.
}
\description{
\code{matexp} computes the exponential of a square matrix A i.e. \eqn{exp(A)}.
}
\details{
This function adapts function \code{expm} from package \pkg{expm}
to be able to handle complex matrices, by decomposing the original
matrix into real and purely imaginary matrices and creating a real
block matrix that function \code{expm} can successfully process.
If the original matrix is real, \code{matexp} calls \code{expm} directly for maximum efficiency.
}
\examples{
A <- matrix(c(1, 2, 2+3i, 5), ncol = 2)  # complex matrix
B <- matrix(1:4, ncol = 2)  # real matrix

matexp(A)
matexp(A, "Ward77")  # uses Ward77's method in function expm
matexp(B)
matexp(B, "Taylor")  # uses Taylor's method in function expm

}
\seealso{
\code{\link[expm]{expm}}
}
\author{
Uffe Høgsbro Thygesen
}
