% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{solve_tridiag}
\alias{solve_tridiag}
\title{Tridiagonal linear system}
\usage{
solve_tridiag(M)
}
\arguments{
\item{M}{The \eqn{n\times (n+1)} augmented matrix of
coefficients corresponding to the system of \eqn{n}
linear equations in \eqn{n} unknowns, \eqn{Ax=b}.}
}
\value{
A vector of length \eqn{n} containing the \eqn{n}
        numeric solutions for the \eqn{n} unknowns. If the
        system has no solutions or an infinite number of
        solutions, the function returns NULL and dumps a
        warning message.
}
\description{
Solution of a system of \eqn{n} equations in \eqn{n} unknowns,
where the coefficients form a tridiagonal matrix.
}
\details{
The linear system to solve is \eqn{Ax=b}, where \eqn{A} is
the \eqn{n\times n} matrix of coefficients of the \eqn{n}
unknowns in the \eqn{n\times 1} vector \eqn{x}, and \eqn{b}
is the \eqn{n\times 1} vector of known numbers. Matrix \eqn{A}
is a tridiagonal matrix. This means that \eqn{A} is a sparse
matrix with non-zero elements on the main diagonal and the
two diagonals adjacent to the main diagonal. The special form
of the matrix of coefficients makes it possible to solve the
related system using a fast algorithm, here the Thomas
algorithm.
}
\examples{
# System of four equations in four unknowns
#
# 2x_1 +  x_2               = 1
# 2x_1 + 3x_2 +  x_3        = 2
#         x_2 + 4x_3 + 2x_4 = 3
#                x_3 + 3x_4 = 4

# Augmented matrix M=(A|b)
M <- matrix(c(2,2,0,0,1,3,1,0,0,1,4,1,0,0,2,3,1,2,3,4),
            ncol=5)

# Solution via Thomas algorithm
x <- solve_tridiag(M)
print(x)

}
