% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.R
\name{deriv_reg}
\alias{deriv_reg}
\title{First derivative on a regular grid}
\usage{
deriv_reg(x0, x, f, scheme = "c")
}
\arguments{
\item{x0}{A numeric vector. Values at which the derivative is computed.
Must be an exact subset of \code{x}. Approximated values of
\code{x} will not be accepted.}

\item{x}{A numeric vector. Regular grid points where the function is tabulated.}

\item{f}{A numeric vector. Tabulated values of the function at grid \code{x}.}

\item{scheme}{A one-letter character indicating which difference to use. 
Possible values are "c", "f", "b" for centred, forward and
backward, respectively.}
}
\value{
A vector of real numbers. These are the numeric approximations to the 
        first derivative of the function at all values in \code{x0}.
}
\description{
Computes the first derivative of a function at selected points using the 
forward difference, backward difference, or centred difference. A regularly
spaced grid with corresponding values of the function must be available,
as well as a subset of the same grid points at which the derivative must
be calculated. For forward and backward differences, the last, respectively 
the derivative cannot be calculated at the first or last grid point. For
centred difference it cannot be calculated at both first and last grid point.
}
\examples{
x <- seq(0, 1, length.out = 11)
f <- x^3 + x^2 - x - 1
x0 <- c(0.2, 0.5, 0.8)
deriv_reg(x0, x, f)

}
