% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardizeFeatures.R
\name{standardizeFeatures}
\alias{standardizeFeatures}
\title{Title}
\usage{
standardizeFeatures(Xs, feature_means = NULL, feature_sds = NULL, verbose = 1)
}
\arguments{
\item{Xs}{Data}

\item{feature_means}{Numeric vector corresponding to columns of elements in Xs}

\item{feature_sds}{Numeric vector corresponding to columns of elements in Xs. If not supplied, will be computed from Xs.}

\item{verbose}{Verbose printing}
}
\value{
Standardizes `data` of objects of class
    `preppedAudio`. Maintains structure of original object
    otherwise. Is used to standardize data where the recording
    environment systematically shifts audio features.
}
\description{
Title
}
\details{
\code{feature_means} and \code{feature_sds} are provided to allow
  alignment of new datasets. For example, after a model is trained, new data
  for prediction must be transformed in the same way as the training data to
  ensure predictions are valid. If either is \code{NULL}, both will be
  computed from \code{Xs} and the output will be internally standardized
  (i.e., columns of \code{do.call(rbind, standardizeFeatures(Xs))} will be
  have a mean of 0 and a standard deviation of 1).
}
\examples{
data('audio')
audio$data <- standardizeFeatures(
    lapply(audio$data, function(x) na.omit(x))
)

}
