% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cllovers.r
\name{cllovers}
\alias{cllovers}
\alias{cllover}
\alias{print.cllover}
\alias{print.cllovers}
\title{Retrieve a user (lover)}
\usage{
cllovers(set = NULL, ..., fmt = "xml")

cllover(user, comments = FALSE, fmt = "xml")
}
\arguments{
\item{set}{Optionally, a subset of COLOURlovers palettes. Allowed values are
\dQuote{new} and \dQuote{top}.}

\item{...}{A named list of parameters passed to the API request. Allowed
parameters are \code{orderCol}, \code{sortBy}, \code{numResults}, and
\code{resultOffset}. Specifying \code{orderCol} overrules any argument to
\code{set}. See details.}

\item{fmt}{A format for the API response, one of \dQuote{xml} (the default)
or \dQuote{json}. This has essentially no effect on function behavior.}

\item{user}{The COLOURlovers username for a specific user.}

\item{comments}{A boolean indicating whether to include the last ten
comments for the user. Default is \code{FALSE}.}
}
\value{
A list of class \dQuote{cllover}, including details about one or
  more users. This should be the same regardless of the value of \code{fmt}.
}
\description{
Retrieve a lover (user) or set of lovers from the COLOURlovers API.
}
\details{
Retrieve details about a COLOURlovers user or users.

Specifying named arguments to \code{...} allows the user to request a
specific response, as follows:

\itemize{
  \item \code{orderCol}: A character string containing a sort criterion. One of
        \dQuote{dateCreated}, \dQuote{score}, \dQuote{name}, \dQuote{numVotes},
        \dQuote{numViews}.
  \item \code{sortBy}: A character string containing either \dQuote{ASC} (for
        ascending by the \code{orderCol} criterion, the default) or \dQuote{DSC}
        (for descending).
  \item \code{numResults}: A numeric value indicating the number of results to
        return, with a maximum of 100. Default is 20.
  \item \code{resultOffset}: A numeric value indicating the page of results to
        return, with page size specified in the \code{numResults} argument.
}
}
\examples{
\dontrun{
# Retrieve top users
cllovers(set = 'top', fmt = 'json')

# Retrieve a single user
cllover('COLOURlovers', fmt = 'json')
}
}
\references{
\url{http://www.colourlovers.com/api/#lovers}
}
\author{
Thomas J. Leeper
}
