% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorCointegration.R
\name{monitorCointegration}
\alias{monitorCointegration}
\title{Procedure for Monitoring Level and Trend Cointegration}
\usage{
monitorCointegration(x, y, m = 0.25, model = c("FM", "D", "IM"),
  trend = FALSE, kernel = c("ba", "pa", "qs", "tr"), bandwidth = c("and",
  "nw"), D.options = NULL, signif.level = 0.05, return.stats = TRUE,
  return.input = TRUE, check = TRUE, ...)
}
\arguments{
\item{x}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
Data on which to apply the monitoring procedure (RHS).}

\item{y}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
Data on which to apply the monitoring procedure (LHS).
Has to be one-dimensional. If \code{matrix}, it may
have only one row or column, if \code{data.frame} just one column.}

\item{m}{[\code{numeric(1)}]\cr
Length of calibration period as fraction of the data's length
(between 0.1 and 0.9) or as number of observations (see Details).}

\item{model}{[\code{character(1)}]\cr
The model to be used for modified OLS calculations. Should be one of
FM-OLS (\code{"FM"}), D-OLS (\code{"D"}) or IM-OLS (\code{"IM"}).}

\item{trend}{[\code{logical}]\cr
Should an intercept and a linear trend be included?
If \code{FALSE} (default), only an intercept is included.}

\item{kernel}{[\code{character(1)}]\cr
The kernel function to use for calculating the long-run variance.
Default is Bartlett kernel (\code{"ba"}), see Details for alternatives.}

\item{bandwidth}{[\code{character(1)} | \code{numeric(1)}]\cr
The bandwidth to use for calculating the long-run variance.
Default is Andrews (1991) (\code{"and"}), an alternative is Newey West
(1994) (\code{"nw"}). You can also set the bandwidth manually.}

\item{D.options}{[\code{list} | \code{NULL}]\cr
Options for the D-OLS calculations. A list with elements \code{n.lead},
\code{n.lag}, \code{kmax} and \code{info.crit} -- or \code{NULL} (then
default arguments are the same as in \code{\link[cointReg]{cointRegD}}.
See that help page for further information.)
Missing list elements will be replaced automatically.}

\item{signif.level}{[\code{numeric(1)}]\cr
Level of significance (between 0.01 and 0.1).
Detection time will be calculated only if the estimated
p-value is smaller than \code{signif.level}. Default is 0.05.}

\item{return.stats}{[\code{logical}]\cr
Whether to return all test statistics. Default is \code{TRUE}.}

\item{return.input}{[\code{logical}]\cr
Whether to return the input data, default is \code{TRUE}.}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link[cointReg]{checkVars}} for further information.}

\item{...}{Arguments passed to \code{\link[cointReg]{getBandwidthNW}} (\code{inter},
\code{weights}), if \code{bandwidth = "nw"}.}
}
\value{
[\code{cointmonitoR}] object with components:
\describe{
  \item{\code{Hsm} [\code{numeric(1)}]}{
    value of the test statistic}

  \item{\code{time} [\code{numeric(1)}]}{
    detected time of structural break}

  \item{\code{p.value} [\code{numeric(1)}]}{
    estimated p-value of the test (between 0.01 and 0.1)}

  \item{\code{cv} [\code{numeric(1)}]}{
    critical value of the test}

  \item{\code{sig} [\code{numeric(1)}]}{
    significance level used for the test}

  \item{\code{residuals} [\code{numeric}]}{
    residuals of the modified OLS model to be used for calculating the
    test statistics}

  \item{\code{model} [\code{character(1)}]}{
    \code{cointOLS} model ("FM", "D", or "IM")}

  \item{\code{trend} [\code{character(1)}]}{
    trend model ("level" or "trend")}

  \item{\code{name} [\code{character(1)}]}{
    name(s) of data}

  \item{\code{m} [\code{list(2)}]}{
    list with components:\cr
    \code{$m.frac} [\code{numeric(1)}]: calibration period (fraction)\cr
    \code{$m.index} [\code{numeric(1)}]: calibration period (length)}

  \item{\code{kernel} [\code{character(1)}]}{
    kernel function}

  \item{\code{bandwidth} [\code{list(2)}]}{
    \code{$name} [\code{character(1)}]: bandwidth function (name)\cr
    \code{$number} [\code{numeric(1)}]: bandwidth}

  \item{\code{statistics} [\code{numeric}]}{
    values of test statistics with the same length as data, but \code{NA}
    during calibration period (available if \code{return.stats = TRUE})}

  \item{\code{input} [\code{numeric} | \code{matrix} | \code{data.frame}]}{
    copy of input data (available if \code{return.stats = TRUE})}

  \item{\code{D.options} [\code{list}]}{
    information about further parameters (available if \code{model = "D"})}
}
}
\description{
This procedure is able to monitor a cointegration model for level or
trend cointegration and returns the corresponding break point, if available.
It is based on parameter estimation on a pre-break "calibration" period
at the beginning of the sample that is known or assumed to be free of
structural change and can be specified exactly via the \code{m} argument
(see Details for further information).
}
\details{
The calibration period can be set by setting the argument \code{m} to the
number of the last observation, that should be inside this period.
The corresponding fraction of the data's length will be calculated
automatically. Alternatively you can set \code{m} directly to the fitting
fraction value, but you should pay attention to the fact, that the
calibration period may become smaller than intended: The last observation
is calculated as \code{floor(m * N)} (with \code{N} the length of x).

The kernel that is used for calculating the long-run variance can be
one of the following:
\itemize{
  \item \code{"ba"}: Bartlett kernel
  \item \code{"pa"}: Parzen kernel
  \item \code{"qs"}: Quadratic Spectral kernel
  \item \code{"tr"}: Truncated kernel
}
}
\examples{
set.seed(42)
x = data.frame(x1 = cumsum(rnorm(200)), x2 = cumsum(rnorm(200)))
eps1 = rnorm(200, sd = 2)
eps2 = c(eps1[1:100], cumsum(eps1[101:200]))

y = x$x1 - x$x2 + 10 + eps1
monitorCointegration(x = x, y = y, m = 0.5, model = "FM")

y2 = y + seq(1, 30, length = 200)
monitorCointegration(x = x, y = y2, m = 0.5, model = "FM")
monitorCointegration(x = x, y = y2, m = 0.5, trend = TRUE, model = "FM")

y3 = x$x1 - x$x2 + 10 + eps2
monitorCointegration(x = x, y = y3, m = 0.5, model = "FM")
monitorCointegration(x = x, y = y3, m = 0.5, model = "D")
monitorCointegration(x = x, y = y3, m = 0.5, model = "IM")

}
\references{
\itemize{
    \item Wagner, M. and D. Wied (2015): "Monitoring Stationarity and
          Cointegration," \emph{Discussion Paper},
          \href{http://dx.doi.org/10.2139/ssrn.2624657}{DOI:10.2139/ssrn.2624657}.
  }
}
\seealso{
Other cointmonitoR: \code{\link{monitorStationarity}},
  \code{\link{plot.cointmonitoR}},
  \code{\link{print.cointmonitoR}}
}

