% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{MCMCrings}
\alias{MCMCrings}
\title{MCMC wiggle-match C-14 dating of a tree}
\usage{
MCMCrings(
  name = "Ulandryk",
  tree.dir = "trees",
  delta.R = 0,
  delta.STD = 10,
  between = c(0, 15000),
  its = 50000,
  x0 = c(),
  xp0 = c(),
  burnin = 1000,
  internal.thinning = 1,
  thinning = c(),
  sep = ",",
  normal = FALSE,
  t.a = 3,
  t.b = 4,
  ask = TRUE,
  prob = 0.95,
  roundby = 1,
  cc = 1,
  postbomb = FALSE,
  BCAD = FALSE,
  talk = TRUE,
  draw = TRUE,
  ...
)
}
\arguments{
\item{name}{Name of the tree. The .csv file should be saved under a folder named exactly the same as \code{name}, and the folder should live under the \code{treedir} folder. The default is Ulandryk.}

\item{tree.dir}{The directory where the folders of the individual trees live. Defaults to \code{tree.dir="trees"}.}

\item{delta.R}{The prior for the mean reservoir age, assuming a normal distribution. Defaults to 0.}

\item{delta.STD}{The prior standard deviation error of the offset, assuming a normal distribution. Set to 10 by default. Changing this value will have impacts on the calculations.}

\item{between}{The range between which the initial ring is assumed to have accumulated. Should contain two values, which the form the limits of the uniform prior distribution for the calendar age. Set to c. Holocene ages by default.}

\item{its}{Amount of MCMC iterations to be run. Defaults to 50000 as a compromise between speed and stability.}

\item{x0}{First set of initial values for calendar age and reservoir effect. Taken from the prior distributions by default.}

\item{xp0}{Second set of initial values for calendar age and reservoir effect. Taken from the prior distributions by default.}

\item{burnin}{Amount of iterations to remove after the run. Defaults to 1000.}

\item{internal.thinning}{Amount of iterations to thin after the run. Defaults to 1.}

\item{thinning}{Amount of iterations to thin after the run. Calculated automatically by default.}

\item{sep}{Separator for the fields in the .csv file. Defaults to a comma.}

\item{normal}{Calculations can be done assuming that the measurements are normally distributed. By default this is set to FALSE and a student-t distribution is used (Christen and Perez 2009)}

\item{t.a}{First parameter for the student-t distribution (defaults to 3; higher numbers make the distribution approximate the normal distribution more).}

\item{t.b}{Second parameter for the student-t distribution (defaults to 4; higher numbers make the distribution approximate the normal distribution more).}

\item{ask}{Whether or not to ask if new folders should be written (if required)}

\item{prob}{Probability range for the hpd calculations. Defaults to 95\%, \code{prob=0.95}.}

\item{roundby}{Rounding of the reported values, defaults to 1 decimal value.}

\item{cc}{Calibration curve to be used, for glueing to a postbomb curve. Could be 1 (IntCal20; default), 2 (Marine20), 3 (SHCal20) or 4 (custom curve). Normally not used, except in the case where there are postbomb dates (requiring the 'gluing' of pre- and postbomb curves).}

\item{postbomb}{Negative C-14 ages should be calibrated using a postbomb curve. This could be 1 (northern-hemisphere region 1), 2 (NH region 2), 3 (NH region 3), 4 (southern hemisphere regions 1-2), or 5 (SH region 3).}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{talk}{Whether or not to provide feedback.}

\item{draw}{Whether or not to draw the graphs.}

\item{...}{Any additional plotting parameters. See draw.MCMCrings.}
}
\description{
Produce a Bayesian wiggle-match date of a tree dated with multiple C-14 dates at exactly known spacing (e.g., every 10 tree-ring years), assuming a constant reservoir effect that affects all dates.
}
\details{
The calculations are based on Bwigg (Christen and Litton 1995; Christen 2003). 

Since two parameters have to be estimated (the age of the earliest, innermost ring and the reservoir effect delta.R), a MCMC approach is used.

The tree files should be in plain-text and fields separated by commas, and the file's extension should be ".csv".
The files should start with a line contain the following headers: "lab ID", "C-14 age", "error", "ring", "cc", separated by commas. Then each row should have the corresponding values, also separated by commas.
Rings are counted from the inner ring (0 year old) outwards, so, forward in time. The file should start with the youngest rings, then work downward until reaching the oldest, bottommost dated rings. 
cc should either be 1 (IntCal20; northern hemisphere terrestrial, 2 (Marine20, though we've never heard of marine trees), 3 (SHCal20; southern hemisphere) or 4 (custom curve). 

The default tree is called Ulandryk (Kuzman et al. 2004). As an alternative, a tree can be simulated (see \code{sim.tree()}).
}
