% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coder-package.R
\docType{package}
\name{coder-package}
\alias{coder}
\alias{coder-package}
\title{coder: Deterministic Categorization of Items Based on External Code Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Fast categorization of items based on external code data identified by regular expressions. A typical use case considers patient with medically coded data, such as codes from the International Classification of Diseases ('ICD') or the Anatomic Therapeutic Chemical ('ATC') classification system. Functions of the package relies on a triad of objects: (1) case data with unit id:s and possible dates of interest; (2) external code data for corresponding units in (1) and with optional dates of interest and; (3) a classification scheme ('classcodes' object) with regular expressions to identify and categorize relevant codes from (2). It is easy to introduce new classification schemes ('classcodes' objects) or to use default schemes included in the package. Use cases includes patient categorization based on 'comorbidity indices' such as 'Charlson', 'Elixhauser', 'RxRisk V', or the 'comorbidity-polypharmacy' score (CPS), as well as adverse events after hip and knee replacement surgery.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/coder/}
  \item Report bugs at \url{https://github.com/ropensci/coder/issues}
}

}
\author{
\strong{Maintainer}: Erik Bulow \email{eriklgb@gmail.com} (\href{https://orcid.org/0000-0002-9973-456X}{ORCID})

Other contributors:
\itemize{
  \item Emely C Zabore (Emily reviewed the package (v. 0.12.1) for rOpenSci, see <https://github.com/ropensci/software-review/issues/381>) [reviewer]
  \item David Robinson (David reviewed the package (v. 0.12.1) for rOpenSci, see <https://github.com/ropensci/software-review/issues/381>) [reviewer]
}

}
\keyword{internal}
