% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivediv.R
\name{division}
\alias{division}
\alias{naivediv}
\alias{longdiv}
\title{Algorithms for divisions}
\usage{
naivediv(m, n)

longdiv(m, n)
}
\arguments{
\item{m}{the dividend}

\item{n}{the divisor}
}
\value{
the quotient and remainder as a list
}
\description{
Algorithms for division that provide a quotient and remainder.
}
\details{
The \code{naivediv} divides \code{m} by \code{n} by using repeated
division.  The \code{longdiv} function uses the long division
algorithm in binary.
}
\examples{
a <- floor(runif(1, 1, 1000))
b <- floor(runif(1, 1, 100))
naivediv(a, b)
longdiv(a, b)

}
\seealso{
Other algebra: 
\code{\link{bilinear}()},
\code{\link{cubicspline}()},
\code{\link{fibonacci}()},
\code{\link{horner}()},
\code{\link{isPrime}()},
\code{\link{linterp}()},
\code{\link{nthroot}()},
\code{\link{polyinterp}()},
\code{\link{pwiselinterp}()},
\code{\link{quadratic}()}
}
\concept{algebra}
