% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cle.rord.R
\name{cle.rord}
\alias{cle.rord}
\title{Composite Likelihood Estimation for Replciations of Spatial Ordinal Data}
\usage{
cle.rord(
  response,
  covar,
  location,
  radius = 4,
  n.sim = 100,
  output = TRUE,
  SE = TRUE,
  parallel = FALSE,
  n.core = max(detectCores()/2, 1),
  ini.sp = c(0.5, 0.5),
  est.method = TRUE,
  maxiter = 100,
  rtol = 1e-06,
  factr = 1e+07
)
}
\arguments{
\item{response}{a matrix of observation (row: spatial site and column: subject).}

\item{covar}{regression (design) matrix, including intercepts.}

\item{location}{a matrix contains spatial location of sites within each subject.}

\item{radius}{radius for selecting pairs for the composite likelihood estimation.}

\item{n.sim}{number of simulation used for parametric bootstrapping (and hence used for asymptotic variance and standard error).}

\item{output}{logical flag indicates whether printing out result (default: \code{TRUE}).}

\item{SE}{logical flag for detailed output.}

\item{parallel}{logical flag indicates using parallel processing (default: \code{FALSE}).}

\item{n.core}{number of physical cores used for parallel processing (when \code{parallel} is \code{TRUE}, default value is \code{max(detectCores()/2,1)}).}

\item{ini.sp}{initial estimate for spatial parameter, \eqn{\phi,\sigma^2} (default: c(0.5,0.5)).}

\item{est.method}{logical flag (default) \code{TRUE} for rootsolve and \code{FALSE} for L-BFGS-B.}

\item{maxiter}{maximum number of iterations in the root solving of gradient function (dafault: 100).}

\item{rtol}{relative error tolerrance  in the root solving of gradient function (default: 1e-6).}

\item{factr}{reduction in the objective (-logCL) within this factor of the machine tolerance for L-BFGS-B (default: 1e7).}
}
\value{
\code{cle.rord} returns a list contains:

\code{vec.par}: a vector of estimator for \eqn{\theta=(\alpha,\beta,\phi,\sigma^2)};

\code{vec.se}: a vector of standard error for the estimator;

\code{mat.asyvar}: estimated asymptotic covariance matrix \eqn{H^{-1}(\theta)J(\theta)H^{-1}(\theta)} for the estimator;

\code{mat.Hessian}: Hessian matrix at the parameter estimate;

\code{mat.J}: Sensitivity matrix estimated by parametric boostrapping; and

\code{CLIC}: Composite likelihood information criterion (see help manual of \code{clic()} for detail).
}
\description{
\code{cle.rord} Estimate parameters (including regression coefficient and cutoff) for replications of spatial ordinal data using pairwise likelihood approach.
}
\details{
Given vector of ordinal responses, the design matrix, spatial location for sites, weight radius (for pair selection), and the prespecified number of simulation used for estimating the Godambe information matrix. Initial estimate is obtained by fitting model without spatial dependence (using \code{MASS::polr()}) and optional guess of spatial parameters. The function first estimates parameters of interest by either solving the gradient of composite log-likelihood using \code{rootSolve::multiroot()} or maximize the composite log-likelihood by \code{optim(..., method="L-BFGS-B")}. The asymptotic covariance matrix and standard error of parameters are then estimated by parametric boostrapping. Although the default root solving option is typically more efficient, it may encounter runtime error if negative value of \eqn{\phi} is evaluated (and L-BFGS-B approach should be used).
}
\examples{
set.seed(1228)
n.subject <- 20
n.lat <- n.lon <- 10
n.site <- n.lat*n.lon

beta <- c(1,2,-1) # First 1 here is the intercept
midalpha <- c(1.15, 2.18) ; phi <- 0.6 ; sigma2 <- 0.7

true <- c(midalpha,beta,phi,sigma2)

Xi <- rnorm(n.subject,0,1) ; Xj <- rbinom(n.site,1,0.6)

 VV <- matrix(NA, nrow = n.subject*n.site, ncol = 3)

 for(i in 1:n.subject){ for(j in 1:n.site){
     VV[(i-1)*n.site+j,] <- c(1,Xi[i],Xj[j])
       }
 }

location <- cbind(rep(seq(1,n.lat,length=n.lat),n.lat),rep(1:n.lon, each=n.lon))
sim.data <- sim.rord(n.subject, n.site, n.rep = 2, midalpha, beta, phi, sigma2, covar=VV, location)

\donttest{
options(digits=3)
result <- cle.rord(response=sim.data[[1]], covar=VV,
          location = location ,radius = 4, n.sim = 100, output = TRUE, parallel=TRUE, n.core =2)
result$vec.par
# alpha2  alpha3   beta0   beta1   beta2     phi sigma^2
# 1.249   2.319   1.169   1.990  -1.000   0.668   0.678

result$vec.se
# alpha2  alpha3   beta0   beta1   beta2     phi sigma^2
# 0.0704  0.1201  0.1370  0.2272  0.0767  0.0346  0.1050

}

}
