\name{sipa_score}
\alias{sipa_score}
\title{
Shock Index, Pediatric Age-adjusted (SIPA)
}
\description{
Calculates the Shock Index (Heart Rate / Systolic BP) and evaluates it against age-specific thresholds to identify blunt trauma patients at risk for severe injury. The SIPA score identifies children with early signs of shock who may have normal vital signs according to traditional reference ranges. Validated primarily for ages 4-16 years.
}
\usage{
sipa_score(age_years, heart_rate, systolic_bp)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. Validated range is 4 to 16 years.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
}
\details{
The Shock Index (SI) is calculated as \eqn{SI = \frac{HR}{SBP}}.
Elevated SIPA is defined as:
\itemize{
  \item Ages 4-6: SI > 1.22
  \item Ages 7-12: SI > 1.00
  \item Ages 13-16: SI > 0.90
}
}
\value{
A list containing:
\item{Shock_Index}{The calculated shock index.}
\item{SIPA_Outcome}{Interpretation of the result (Normal vs. Elevated).}
\item{Age_Cutoff_Used}{The threshold applied based on the patient's age.}
}
\references{
Acker SN, Ross JT, Partrick DA, Tong S, Bensard DD. Pediatric specific shock index accurately identifies severely injured children. J Pediatr Surg. 2015;50(2):331-334. doi:10.1016/j.jpedsurg.2014.08.009
Acker SN, et al. Shock index, pediatric age-adjusted (SIPA) is more accurate than age-adjusted hypotension for identifying severely injured children. Surgery. 2017;161(4):803-809.
}
\examples{

# Example 1: 5-year-old with elevated SIPA
# HR 130, SBP 100 -> SI = 1.30 (> 1.22)
sipa_score(5, 130, 100)

# Example 2: 10-year-old with normal SIPA
# HR 90, SBP 110 -> SI = 0.82 (<= 1.00)
sipa_score(10, 90, 110)
}
