\name{phq9_score}
\alias{phq9_score}
\title{
Patient Health Questionnaire-9 (PHQ-9)
}
\description{
Calculates the PHQ-9 total score to screen for and measure the severity of depression. The scale consists of 9 items corresponding to the DSM-IV criteria for major depressive disorder.
}
\usage{
phq9_score(interest, depressed, sleep, energy, appetite, failure,
           concentration, psychomotor, suicide)
}
\arguments{
  \item{interest}{
Numeric (0-3). Little interest or pleasure in doing things.
0: Not at all
1: Several days
2: More than half the days
3: Nearly every day
}
  \item{depressed}{
Numeric (0-3). Feeling down, depressed, or hopeless.
}
  \item{sleep}{
Numeric (0-3). Trouble falling or staying asleep, or sleeping too much.
}
  \item{energy}{
Numeric (0-3). Feeling tired or having little energy.
}
  \item{appetite}{
Numeric (0-3). Poor appetite or overeating.
}
  \item{failure}{
Numeric (0-3). Feeling bad about yourself - or that you are a failure or have let yourself or your family down.
}
  \item{concentration}{
Numeric (0-3). Trouble concentrating on things, such as reading the newspaper or watching television.
}
  \item{psychomotor}{
Numeric (0-3). Moving or speaking so slowly that other people could have noticed? Or the opposite - being so fidgety or restless that you have been moving around a lot more than usual.
}
  \item{suicide}{
Numeric (0-3). Thoughts that you would be better off dead or of hurting yourself in some way.
}
}
\value{
A list containing:
\item{PHQ9_Score}{The calculated total score (Range 0-27).}
\item{Severity}{Depression severity category (None-minimal, Mild, Moderate, Moderately Severe, Severe).}
}
\references{
Kroenke K, Spitzer RL, Williams JB. The PHQ-9: validity of a brief depression severity measure. J Gen Intern Med. 2001;16(9):606-613. doi:10.1046/j.1525-1497.2001.016009606.x
}
\examples{

# Example 1: Moderate Depression
# Several days (1) for most, More than half (2) for sleep/energy
phq9_score(1, 1, 2, 2, 1, 1, 1, 1, 0)

# Example 2: Severe Depression
# Nearly every day (3) for most items
phq9_score(3, 3, 3, 3, 2, 3, 2, 3, 1)
}
