\name{nincds_adrda_criteria}
\alias{nincds_adrda_criteria}
\title{
NINCDS-ADRDA Criteria for Alzheimer's Disease
}
\description{
Evaluates the NINCDS-ADRDA (National Institute of Neurological and Communicative Disorders and Stroke and the Alzheimer's Disease and Related Disorders Association) clinical criteria for the diagnosis of Alzheimer's Disease. The criteria classify patients into Definite, Probable, or Possible Alzheimer's Disease based on clinical findings and exclusion of other causes.
}
\usage{
nincds_adrda_criteria(dementia_established, multiple_cognitive_deficits,
                      progressive_worsening, no_consciousness_disturbance,
                      onset_age_40_90, absence_of_other_disorders,
                      histopathology_evidence = 0)
}
\arguments{
  \item{dementia_established}{
Numeric (0 or 1). Dementia established by clinical examination and documented by the Mini-Mental Test, Blessed Dementia Scale, or similar examination. (1 = Yes).
}
  \item{multiple_cognitive_deficits}{
Numeric (0 or 1). Deficits in two or more areas of cognition. (1 = Yes).
}
  \item{progressive_worsening}{
Numeric (0 or 1). Progressive worsening of memory and other cognitive functions. (1 = Yes).
}
  \item{no_consciousness_disturbance}{
Numeric (0 or 1). No disturbance of consciousness. (1 = Yes).
}
  \item{onset_age_40_90}{
Numeric (0 or 1). Onset between ages 40 and 90. (1 = Yes).
}
  \item{absence_of_other_disorders}{
Numeric (0 or 1). Absence of systemic disorders or other brain diseases that could account for the progressive deficits in memory and cognition. (1 = Yes).
}
  \item{histopathology_evidence}{
Numeric (0 or 1). Histopathologic evidence of Alzheimer's Disease obtained from biopsy or autopsy. (1 = Yes). Required for "Definite" diagnosis.
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting diagnostic classification: "Definite Alzheimer's Disease", "Probable Alzheimer's Disease", "Possible Alzheimer's Disease", or "Unlikely Alzheimer's Disease".}
}
\references{
McKhann G, Drachman D, Folstein M, Katzman R, Price D, Stadlan EM. Clinical diagnosis of Alzheimer's disease: report of the NINCDS-ADRDA Work Group under the auspices of Department of Health and Human Services Task Force on Alzheimer's Disease. Neurology. 1984;34(7):939-944. doi:10.1212/wnl.34.7.939
}
\examples{

# Example 1: Probable AD
# All core criteria met, no biopsy
nincds_adrda_criteria(1, 1, 1, 1, 1, 1, 0)

# Example 2: Definite AD
# All core criteria met + Biopsy confirmed
nincds_adrda_criteria(1, 1, 1, 1, 1, 1, 1)

# Example 3: Possible AD (Comorbidity)
# All core criteria met EXCEPT absence of other disorders (0)
nincds_adrda_criteria(1, 1, 1, 1, 1, 0, 0)
}
