\name{ipi_score_dlbcl}
\alias{ipi_score_dlbcl}
\title{
International Prognostic Index (IPI) for Diffuse Large B-Cell Lymphoma
}
\description{
Calculates the IPI Score to predict prognosis in patients with Diffuse Large B-Cell Lymphoma (DLBCL). The score provides risk stratification based on the standard IPI model (pre-Rituximab era) and the Revised-IPI (R-IPI) model (Rituximab era). It uses five clinical factors: Age, Ann Arbor Stage, Serum LDH, ECOG Performance Status, and Number of Extranodal Sites.
}
\usage{
ipi_score_dlbcl(age, stage, ldh_ratio, performance_status, extranodal_sites)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>60 adds 1 point).
}
  \item{stage}{
Numeric. Ann Arbor Stage (1-4). (Stage III or IV adds 1 point).
}
  \item{ldh_ratio}{
Numeric. Ratio of patient's LDH to the upper limit of normal (ULN). (>1.0 adds 1 point).
}
  \item{performance_status}{
Numeric. ECOG Performance Status (0-4). (>=2 adds 1 point).
}
  \item{extranodal_sites}{
Numeric. Number of extranodal sites involved. (>1 adds 1 point).
}
}
\value{
A list containing:
\item{IPI_Score}{The calculated total score (Range 0-5).}
\item{Standard_IPI_Classification}{Risk group and survival estimate based on the original IPI study.}
\item{Revised_IPI_Classification}{Risk group and survival estimate based on the R-IPI study (Rituximab-treated patients).}
}
\references{
The International Non-Hodgkin's Lymphoma Prognostic Factors Project. A predictive model for aggressive non-Hodgkin's lymphoma. N Engl J Med. 1993;329(14):987-994. doi:10.1056/NEJM199309303291402
Sehn LH, Berry B, Chhanabhai M, et al. The revised International Prognostic Index (R-IPI) is a better predictor of outcome than the standard IPI for patients with diffuse large B-cell lymphoma treated with R-CHOP. Blood. 2007;109(5):1857-1861. doi:10.1182/blood-2006-08-038257
}
\examples{

# Example 1: High Risk (Standard) / Poor Risk (R-IPI)
# Age 70 (+1), Stage IV (+1), LDH 2x (+1), ECOG 1 (0), 2 Extranodal (+1)
# Score = 4
ipi_score_dlbcl(70, 4, 2.0, 1, 2)

# Example 2: Low Risk (Standard) / Very Good Risk (R-IPI)
# Age 50 (0), Stage II (0), LDH 0.8 (0), ECOG 0 (0), 0 Extranodal (0)
# Score = 0
ipi_score_dlbcl(50, 2, 0.8, 0, 0)
}
