\name{improve_vte_risk_score}
\alias{improve_vte_risk_score}
\title{
IMPROVE Risk Score for Venous Thromboembolism (VTE)
}
\description{
Calculates the IMPROVE VTE Risk Score to predict the 3-month risk of symptomatic VTE in acutely ill hospitalized medical patients. The score helps identify patients who may benefit from thromboprophylaxis.
}
\usage{
improve_vte_risk_score(previous_vte, known_thrombophilia, lower_limb_paralysis,
                       current_cancer, immobilized_ge_7days, icu_ccu_stay,
                       age_gt_60)
}
\arguments{
  \item{previous_vte}{
Numeric (0 or 1). History of previous VTE. (1 = Yes, +3 points).
}
  \item{known_thrombophilia}{
Numeric (0 or 1). Known thrombophilia (congenital or acquired). (1 = Yes, +2 points).
}
  \item{lower_limb_paralysis}{
Numeric (0 or 1). Current lower-limb paralysis or paresis. (1 = Yes, +2 points).
}
  \item{current_cancer}{
Numeric (0 or 1). Active cancer (excluding non-melanoma skin cancer). (1 = Yes, +2 points).
}
  \item{immobilized_ge_7days}{
Numeric (0 or 1). Immobilization for >= 7 days immediately prior to and during admission. (1 = Yes, +1 point).
}
  \item{icu_ccu_stay}{
Numeric (0 or 1). Stay in an Intensive Care Unit (ICU) or Coronary Care Unit (CCU). (1 = Yes, +1 point).
}
  \item{age_gt_60}{
Numeric (0 or 1). Age > 60 years. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{IMPROVE_VTE_Score}{The calculated risk score (Range 0-12).}
\item{Est_3_Month_VTE_Risk}{Estimated percentage risk of symptomatic VTE at 3 months.}
\item{Recommendation}{Clinical guidance regarding prophylaxis.}
}
\references{
Spyropoulos AC, Anderson FA Jr, FitzGerald G, et al. Predictive and associative models to identify hospitalized medical patients at risk for VTE. Chest. 2011;140(3):706-714. doi:10.1378/chest.10-1944
}
\examples{

# Example 1: High Risk
# Prior VTE (+3), Cancer (+2), Age >60 (+1)
# Score = 6
improve_vte_risk_score(1, 0, 0, 1, 0, 0, 1)

# Example 2: Low Risk
# Age >60 only
# Score = 1
improve_vte_risk_score(0, 0, 0, 0, 0, 0, 1)
}
