\name{imdc_risk_score}
\alias{imdc_risk_score}
\title{
IMDC (Heng) Risk Model for Metastatic Renal Cell Carcinoma
}
\description{
Calculates the International Metastatic Renal Cell Carcinoma Database Consortium (IMDC) risk score. This prognostic model stratifies patients with metastatic renal cell carcinoma (mRCC) treated with targeted therapy (VEGF-targeted agents) into Favorable, Intermediate, or Poor risk groups based on six clinical factors.
}
\usage{
imdc_risk_score(time_to_therapy_lt_1yr, kps_lt_80, hemoglobin_lt_lln,
                calcium_gt_uln, neutrophils_gt_uln, platelets_gt_uln)
}
\arguments{
  \item{time_to_therapy_lt_1yr}{
Numeric (0 or 1). Less than 1 year from the time of diagnosis to the start of systemic therapy. (1 = Yes).
}
  \item{kps_lt_80}{
Numeric (0 or 1). Karnofsky Performance Status < 80\%. (1 = Yes).
}
  \item{hemoglobin_lt_lln}{
Numeric (0 or 1). Hemoglobin less than the Lower Limit of Normal (LLN). (1 = Yes).
}
  \item{calcium_gt_uln}{
Numeric (0 or 1). Corrected Calcium greater than the Upper Limit of Normal (ULN). (1 = Yes).
}
  \item{neutrophils_gt_uln}{
Numeric (0 or 1). Neutrophil count greater than the Upper Limit of Normal (ULN). (1 = Yes).
}
  \item{platelets_gt_uln}{
Numeric (0 or 1). Platelet count greater than the Upper Limit of Normal (ULN). (1 = Yes).
}
}
\value{
A list containing:
\item{IMDC_Score}{The calculated total count of risk factors (Range 0-6).}
\item{Risk_Group}{Classification (Favorable: 0, Intermediate: 1-2, Poor: >=3).}
\item{Median_Overall_Survival}{Estimated median overall survival based on the original validation cohort.}
}
\references{
Heng DY, Xie W, Regan MM, et al. Prognostic factors for overall survival in patients with metastatic renal cell carcinoma treated with vascular endothelial growth factor-targeted agents: results from a large, multicenter study. J Clin Oncol. 2009;27(34):5794-5799. doi:10.1200/JCO.2008.21.4809
}
\examples{

# Example 1: Poor Risk
# <1yr to tx, Low KPS, Anemia
# Score = 3
imdc_risk_score(1, 1, 1, 0, 0, 0)

# Example 2: Favorable Risk
# No risk factors present
# Score = 0
imdc_risk_score(0, 0, 0, 0, 0, 0)
}
