\name{dsm5_binge_eating_disorder}
\alias{dsm5_binge_eating_disorder}
\title{
DSM-5 Diagnostic Criteria for Binge Eating Disorder (BED)
}
\description{
Evaluates the diagnostic criteria for Binge Eating Disorder according to the DSM-5. It checks for recurrent episodes, associated symptoms, distress, frequency/duration, and the absence of compensatory behaviors (ruling out Bulimia Nervosa). It also specifies severity based on the frequency of episodes per week.
}
\usage{
dsm5_binge_eating_disorder(recurrent_episodes, symptom_count, marked_distress,
                           time_criteria_met, no_compensatory_behavior,
                           frequency_per_week)
}
\arguments{
  \item{recurrent_episodes}{
Numeric (0 or 1). Criterion A: Recurrent episodes of binge eating characterized by eating a large amount in a discrete period and a lack of control. (1 = Yes).
}
  \item{symptom_count}{
Numeric (0-5). Criterion B: Number of associated symptoms present (Eating rapidly, Eating until uncomfortably full, Eating large amounts when not hungry, Eating alone due to embarrassment, Feeling disgusted/guilty). Diagnosis requires >= 3.
}
  \item{marked_distress}{
Numeric (0 or 1). Criterion C: Marked distress regarding binge eating is present. (1 = Yes).
}
  \item{time_criteria_met}{
Numeric (0 or 1). Criterion D: The binge eating occurs, on average, at least once a week for 3 months. (1 = Yes).
}
  \item{no_compensatory_behavior}{
Numeric (0 or 1). Criterion E: The binge eating is NOT associated with recurrent use of inappropriate compensatory behavior (e.g., purging) and does not occur exclusively during the course of bulimia nervosa or anorexia nervosa. (1 = Yes, criteria met).
}
  \item{frequency_per_week}{
Numeric. The number of binge eating episodes per week (used for severity specification).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met" or "Criteria Not Met".}
\item{Severity_Specification}{Classification based on frequency (Mild, Moderate, Severe, Extreme).}
\item{Missing_Criteria}{List of specific criteria that were not satisfied.}
}
\references{
American Psychiatric Association. Diagnostic and Statistical Manual of Mental Disorders. 5th ed. Arlington, VA: American Psychiatric Association; 2013.
}
\examples{

# Example 1: Moderate BED
# Recurrent(1), 4 symptoms(4), Distress(1), Time Met(1), No Purging(1), 5x/week
dsm5_binge_eating_disorder(1, 4, 1, 1, 1, 5)

# Example 2: Criteria Not Met (Symptom Count)
# Recurrent(1), only 1 symptom(1), Distress(1), Time Met(1), No Purging(1), 2x/week
dsm5_binge_eating_disorder(1, 1, 1, 1, 1, 2)
}
