\name{canadian_c_spine_rule}
\alias{canadian_c_spine_rule}
\title{
Canadian C-Spine Rule (CCR)
}
\description{
Implements the Canadian C-Spine Rule to determine the need for cervical spine radiography in alert and stable trauma patients. The rule proceeds through three stages: identifying high-risk factors (mandating imaging), identifying low-risk factors (allowing range of motion assessment), and assessing the ability to actively rotate the neck.
}
\usage{
canadian_c_spine_rule(age, dangerous_mechanism, paresthesias_extremities,
                      simple_rear_end_mva, sitting_in_ed, ambulatory_at_any_time,
                      delayed_onset_neck_pain, midline_c_spine_tenderness,
                      able_to_rotate_45_degrees)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 65 is a High Risk factor).
}
  \item{dangerous_mechanism}{
Numeric (0 or 1). Fall from >= 1m/5 stairs, axial load to head, high-speed MVC (>100km/h), rollover, ejection, motorized recreational vehicle, or bicycle struck/collision. (1 = Yes).
}
  \item{paresthesias_extremities}{
Numeric (0 or 1). Presence of paresthesias in extremities. (1 = Yes).
}
  \item{simple_rear_end_mva}{
Numeric (0 or 1). Simple rear-end motor vehicle collision (EXCLUDES: pushed into oncoming traffic, hit by bus/large truck, rollover, or hit by high-speed vehicle). (1 = Yes).
}
  \item{sitting_in_ed}{
Numeric (0 or 1). Patient is sitting in the emergency department. (1 = Yes).
}
  \item{ambulatory_at_any_time}{
Numeric (0 or 1). Patient has been ambulatory at any time since the injury. (1 = Yes).
}
  \item{delayed_onset_neck_pain}{
Numeric (0 or 1). Neck pain was not immediate (i.e., delayed onset). (1 = Yes).
}
  \item{midline_c_spine_tenderness}{
Numeric (0 or 1). Presence of midline cervical spine tenderness. (1 = Yes, 0 = No). Note: ABSENCE of tenderness is the low-risk factor.
}
  \item{able_to_rotate_45_degrees}{
Numeric (0 or 1). Patient is able to actively rotate neck 45 degrees to the left and right. (1 = Yes).
}
}
\value{
A list containing:
\item{Recommendation}{"Radiography Indicated" or "No Radiography Needed".}
\item{Risk_Reasoning}{The specific stage of the rule that determined the outcome (e.g., "High Risk", "Inability to Rotate Neck").}
}
\references{
Stiell IG, Wells GA, Vandemheen KL, et al. The Canadian C-spine rule for radiography in alert and stable trauma patients. JAMA. 2001;286(15):1841-1848. doi:10.1001/jama.286.15.1841
}
\examples{

# Example 1: High Risk (Age)
# 70yo, minor fall
canadian_c_spine_rule(70, 0, 0, 0, 1, 1, 0, 0, 1)

# Example 2: Cleared (Low Risk Factor + Rotation)
# 30yo, Simple Rear End, No midline tenderness, Can rotate
canadian_c_spine_rule(30, 0, 0, 1, 1, 1, 1, 0, 1)

# Example 3: Imaging Needed (Cannot Rotate)
# 30yo, Simple Rear End, but cannot rotate 45 degrees
canadian_c_spine_rule(30, 0, 0, 1, 1, 1, 1, 0, 0)
}
