\name{calculate_map}
\alias{calculate_map}
\title{
Mean Arterial Pressure (MAP)
}
\description{
Calculates the Mean Arterial Pressure (MAP), which represents the average arterial pressure during a single cardiac cycle. It is considered a better indicator of perfusion to vital organs than systolic blood pressure alone.
}
\usage{
calculate_map(systolic_bp, diastolic_bp)
}
\arguments{
  \item{systolic_bp}{
Numeric. Systolic Blood Pressure in mmHg.
}
  \item{diastolic_bp}{
Numeric. Diastolic Blood Pressure in mmHg.
}
}
\details{
The formula used is:
\deqn{MAP = \frac{SBP + (2 \times DBP)}{3}}
}
\value{
A list containing:
\item{Mean_Arterial_Pressure}{The calculated MAP in mmHg.}
}
\references{
Geddes LA, Cheever E, Tacker WA, et al. The direct measurement of mean blood pressure in the canine. Cardiovasc Res Ctr Bull. 1976;15(4):99-103.
}
\examples{

# Example 1: Normal BP
# 120/80
calculate_map(120, 80)

# Example 2: Hypotension
# 85/50
calculate_map(85, 50)
}
