\name{atlas_cdi_score}
\alias{atlas_cdi_score}
\title{
ATLAS Score for Clostridium Difficile Infection
}
\description{
Calculates the ATLAS Score to predict cure rates and 30-day mortality in patients with Clostridium difficile infection (CDI). The score evaluates Age, Treatment with systemic antibiotics, Leukocyte count, Albumin, and Serum creatinine.
}
\usage{
atlas_cdi_score(age, systemic_abx, wbc_count, albumin, creatinine,
                albumin_units = "g/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (<60: 0 pts; 60-79: 1 pt; >=80: 2 pts).
}
  \item{systemic_abx}{
Numeric (0 or 1). Concomitant treatment with systemic antibiotics during CDI therapy. (1 = Yes: 2 pts; 0 = No: 0 pts).
}
  \item{wbc_count}{
Numeric. White Blood Cell count. Can be entered as cells/uL (e.g., 16000) or k/uL (e.g., 16.0). (<16k: 0 pts; 16k-25k: 1 pt; >25k: 2 pts).
}
  \item{albumin}{
Numeric. Serum albumin level. (>3.5 g/dL: 0 pts; 2.6-3.5 g/dL: 1 pt; <=2.5 g/dL: 2 pts).
}
  \item{creatinine}{
Numeric. Serum creatinine level. (<=1.3 mg/dL: 0 pts; 1.4-2.0 mg/dL: 1 pt; >2.0 mg/dL: 2 pts).
}
  \item{albumin_units}{
String. Units for albumin. "g/dL" (default) or "g/L".
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{ATLAS_Score}{The calculated score (Range 0-10).}
\item{Predicted_Cure_Rate}{Estimated probability of cure.}
\item{Predicted_Mortality_30_Day}{Estimated 30-day mortality risk.}
}
\references{
Miller MA, et al. Derivation and validation of a simple clinical bedside score (ATLAS) for Clostridium difficile infection which predicts response to therapy. BMC Infect Dis. 2013;13:148.
}
\examples{

# Example 1: Low Risk
# 45yo, No abx, WBC 10k, Alb 4.0, Cr 0.9
atlas_cdi_score(45, 0, 10000, 4.0, 0.9)

# Example 2: High Risk
# 85yo (+2), On Abx (+2), WBC 26k (+2), Alb 2.0 (+2), Cr 2.5 (+2)
# Score = 10
atlas_cdi_score(85, 1, 26000, 2.0, 2.5)
}
