\name{asthma_predictive_index}
\alias{asthma_predictive_index}
\title{
Asthma Predictive Index (API)
}
\description{
Calculates the Stringent Asthma Predictive Index (API) to predict the likelihood of developing active asthma at school age in children younger than 3 years who present with frequent wheezing. This tool is based on the original Castro-Rodriguez criteria derived from the Tucson Children's Respiratory Study.
}
\usage{
asthma_predictive_index(wheezing_freq_ge_4, parent_asthma, eczema,
                        allergic_rhinitis, wheezing_apart_colds,
                        eosinophilia_ge_4)
}
\arguments{
  \item{wheezing_freq_ge_4}{
Numeric (0 or 1). Does the child have a history of frequent wheezing (>= 4 episodes/year) with at least one physician-confirmed episode? (Entry Criterion).
}
  \item{parent_asthma}{
Numeric (0 or 1). Parental history of asthma. (Major Criterion).
}
  \item{eczema}{
Numeric (0 or 1). Physician-diagnosed atopic dermatitis (eczema). (Major Criterion).
}
  \item{allergic_rhinitis}{
Numeric (0 or 1). Physician-diagnosed allergic rhinitis. (Minor Criterion).
}
  \item{wheezing_apart_colds}{
Numeric (0 or 1). Wheezing apart from colds. (Minor Criterion).
}
  \item{eosinophilia_ge_4}{
Numeric (0 or 1). Peripheral eosinophilia >= 4\%. (Minor Criterion).
}
}
\value{
A list containing:
\item{Result}{"Positive Stringent API" or "Negative Stringent API".}
\item{Interpretation}{Prognostic information regarding the risk of asthma at ages 6-13.}
\item{Stats}{Predictive values (PPV, Specificity) derived from the validation studies.}
}
\references{
Castro-Rodriguez JA, Holberg CJ, Wright AL, Martinez FD. A clinical index to define risk of asthma in young children with recurrent wheeze. Am J Respir Crit Care Med. 2000;162(4 Pt 1):1403-1406. doi:10.1164/ajrccm.162.4.9912111
}
\examples{

# Example 1: Positive API
# Freq wheezing, Parent Asthma (Major), No others
# Result: Positive (1 Major met)
asthma_predictive_index(1, 1, 0, 0, 0, 0)

# Example 2: Positive API via Minor Criteria
# Freq wheezing, No Major, Allergic Rhinitis + Eosinophilia (2 Minor)
asthma_predictive_index(1, 0, 0, 1, 0, 1)

# Example 3: Negative API
# Freq wheezing, only Eosinophilia (1 Minor)
asthma_predictive_index(1, 0, 0, 0, 0, 1)
}
