\name{sudbury_vertigo_risk_score}
\alias{sudbury_vertigo_risk_score}
\title{
Sudbury Vertigo Risk Score
}
\description{
Calculates the Sudbury Vertigo Risk Score to stratify the risk of cerebrovascular events (stroke/TIA) in patients presenting with vertigo or dizziness. The score is based on demographic and vascular risk factors.
}
\usage{
sudbury_vertigo_risk_score(age_years, sex, hypertension, diabetes,
                           dyslipidemia, coronary_artery_disease,
                           history_stroke_tia, smoker)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. (Age >= 65 adds 1 point).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds 1 point).
}
  \item{hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes, +1 point).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes mellitus. (1 = Yes, +1 point).
}
  \item{dyslipidemia}{
Numeric (0 or 1). History of dyslipidemia/high cholesterol. (1 = Yes, +1 point).
}
  \item{coronary_artery_disease}{
Numeric (0 or 1). History of coronary artery disease (MI, angina, CABG/PCI). (1 = Yes, +1 point).
}
  \item{history_stroke_tia}{
Numeric (0 or 1). History of prior stroke or Transient Ischemic Attack (TIA). (1 = Yes, +1 point).
}
  \item{smoker}{
Numeric (0 or 1). Current smoker. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Sudbury_Score}{The calculated total risk score (Range 0-8).}
\item{Risk_Category}{Classification of stroke risk (Low, Moderate, High).}
}
\references{
Tran D, et al. Derivation of a clinical decision rule for the prediction of stroke in patients with vertigo: the Sudbury Vertigo Risk Score. (Ongoing validation studies).
}
\examples{

# Example 1: High Risk
# 70yo Male (+2), HTN (+1), DM (+1), CAD (+1)
# Score = 5
sudbury_vertigo_risk_score(70, "male", 1, 1, 0, 1, 0, 0)

# Example 2: Low Risk
# 40yo Female, No risk factors
# Score = 0
sudbury_vertigo_risk_score(40, "female", 0, 0, 0, 0, 0, 0)
}
