\name{stone_nephrolithometry_score}
\alias{stone_nephrolithometry_score}
\title{
STONE Nephrolithometry Score
}
\description{
Calculates the S.T.O.N.E. Nephrolithometry Score to predict the complexity of Percutaneous Nephrolithotomy (PCNL) and estimated stone-free rates. The score is based on 5 parameters: Stone size, Tract length, Obstruction, Number of involved calyces, and Essence (stone density).
}
\usage{
stone_nephrolithometry_score(stone_size_mm2, tract_length_mm, obstruction_degree,
                             number_involved_calyces, stone_density_hu)
}
\arguments{
  \item{stone_size_mm2}{
Numeric. Stone surface area in mm^2 (typically Length x Width x pi x 0.25).
<400: 1 pt.
400-799: 2 pts.
800-1599: 3 pts.
>=1600: 4 pts.
}
  \item{tract_length_mm}{
Numeric. Skin-to-stone distance in mm (average of 3 distances on CT).
<=100: 1 pt.
>100: 2 pts.
}
  \item{obstruction_degree}{
String. Degree of hydronephrosis.
"none_mild": 1 pt.
"moderate_severe": 2 pts.
}
  \item{number_involved_calyces}{
String. Number of calyces containing stones.
"1_or_2": 1 pt.
"3": 2 pts.
"staghorn": 3 pts.
}
  \item{stone_density_hu}{
Numeric. Stone density in Hounsfield Units.
<=950: 1 pt.
>950: 2 pts.
}
}
\value{
A list containing:
\item{STONE_Score}{The calculated total score (Range 5-13).}
\item{Surgical_Complexity}{Classification (Low, Moderate, High).}
\item{Est_Stone_Free_Rate}{Estimated likelihood of achieving stone-free status.}
}
\references{
Okhunov Z, Friedlander JI, George AK, et al. S.T.O.N.E. nephrolithometry: novel surgical classification system for kidney calculi. Urology. 2013;81(6):1154-1159. doi:10.1016/j.urology.2012.10.083
}
\examples{

# Example 1: Low Complexity
# 300mm2, 80mm tract, Mild Hydro, 1 calyx, 800 HU
# Score = 1 + 1 + 1 + 1 + 1 = 5
stone_nephrolithometry_score(300, 80, "none_mild", "1_or_2", 800)

# Example 2: High Complexity
# 1700mm2, 120mm tract, Severe Hydro, Staghorn, 1200 HU
# Score = 4 + 2 + 2 + 3 + 2 = 13
stone_nephrolithometry_score(1700, 120, "moderate_severe", "staghorn", 1200)
}
