\name{roth_hypoxia_score}
\alias{roth_hypoxia_score}
\title{
Roth Score for Hypoxia Screening
}
\description{
Calculates the Roth Score risk stratification for hypoxia. This simple bedside test involves the patient taking a deep breath and counting out loud from 1 to 30 as fast as possible. The highest number reached (Max Count) correlates with pulse oximetry (SpO2) levels. It is often used as a screening tool for telemedicine or when pulse oximetry is unavailable.
}
\usage{
roth_hypoxia_score(max_count_reached, duration_seconds)
}
\arguments{
  \item{max_count_reached}{
Numeric. The highest number the patient reached in a single breath counting out loud as fast as possible.
}
  \item{duration_seconds}{
Numeric. The total time in seconds elapsed during the count. (Used primarily for clinical context/verification of effort).
}
}
\value{
A list containing:
\item{Max_Count}{The input count.}
\item{Risk_Category}{Risk classification (High, Intermediate, Low) based on the count threshold.}
\item{Diagnostic_Performance}{Sensitivity metrics for detecting SpO2 < 95\% based on the count.}
}
\references{
Chorath K, Prine L, Ludmir J, et al. The Roth Score: A Novel Method for Assessing Hypoxia. Telemedicine and e-Health. 2021.
}
\examples{

# Example 1: High Risk
# Patient reached 5 in 4 seconds
roth_hypoxia_score(5, 4)

# Example 2: Low Risk
# Patient reached 25 in 10 seconds
roth_hypoxia_score(25, 10)
}
