\name{qcsi_score}
\alias{qcsi_score}
\title{
Quick COVID-19 Severity Index (qCSI)
}
\description{
Calculates the qCSI score to predict the 24-hour risk of critical respiratory illness (defined as high-flow oxygen, non-invasive ventilation, intubation, or death) in patients admitted with COVID-19. The score relies on three bedside variables: respiratory rate, pulse oximetry, and oxygen flow rate.
}
\usage{
qcsi_score(respiratory_rate, oxygen_saturation, o2_flow_rate)
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
<= 22: 0 pts.
23-28: 1 pt.
> 28: 2 pts.
}
  \item{oxygen_saturation}{
Numeric. Minimum documented pulse oximetry (SpO2) percent.
> 92: 0 pts.
89-92: 2 pts.
<= 88: 5 pts.
}
  \item{o2_flow_rate}{
Numeric. Oxygen flow rate in Liters per minute (L/min) at the time of minimum SpO2.
0 (Room air): 0 pts.
1-2 L/min: 4 pts.
3-4 L/min: 5 pts.
>= 5 L/min: 6 pts.
}
}
\value{
A list containing:
\item{qCSI_Score}{The calculated total score (Range 0-12).}
\item{Risk_Category}{Risk classification (Low, Low-Intermediate, High-Intermediate, High).}
\item{Est_24hr_Critical_Illness_Risk}{Estimated probability of critical illness within 24 hours.}
}
\references{
Haimovich AD, Ravindra NG, Stoytchev S, et al. Development and Validation of the Quick COVID-19 Severity Index: A Prognostic Tool for Early Clinical Decompensation. Ann Emerg Med. 2020;76(4):442-453. doi:10.1016/j.annemergmed.2020.07.022
}
\examples{

# Example 1: Low Risk
# RR 18, SpO2 95%, Room Air (0L)
# Score = 0
qcsi_score(18, 95, 0)

# Example 2: High Risk
# RR 30 (+2), SpO2 88% (+5), 4L O2 (+5)
# Score = 12
qcsi_score(30, 88, 4)
}
