\name{panss_score}
\alias{panss_score}
\title{
Positive and Negative Syndrome Scale (PANSS) for Schizophrenia
}
\description{
Calculates the PANSS score, a comprehensive standard for assessing the severity of schizophrenia symptoms. It is divided into three subscales: Positive (P), Negative (N), and General Psychopathology (G). The total score ranges from 30 to 210.
}
\usage{
panss_score(positive_scale_items, negative_scale_items,
            general_psychopathology_items)
}
\arguments{
  \item{positive_scale_items}{
Numeric vector of length 7. Scores for items P1 through P7 (e.g., Delusions, Conceptual disorganization). Each item is scored 1 (Absent) to 7 (Extreme).
}
  \item{negative_scale_items}{
Numeric vector of length 7. Scores for items N1 through N7 (e.g., Blunted affect, Emotional withdrawal). Each item is scored 1 (Absent) to 7 (Extreme).
}
  \item{general_psychopathology_items}{
Numeric vector of length 16. Scores for items G1 through G16 (e.g., Somatic concern, Anxiety, Guilt feelings). Each item is scored 1 (Absent) to 7 (Extreme).
}
}
\value{
A list containing:
\item{PANSS_Total_Score}{The sum of all 30 items (Range 30-210).}
\item{Severity_Estimate}{Clinical impression based on Leucht et al. cutoffs.}
\item{Subscales}{A list containing the individual sums for the Positive, Negative, and General subscales.}
}
\references{
Kay SR, Fiszbein A, Opler LA. The positive and negative syndrome scale (PANSS) for schizophrenia. Schizophr Bull. 1987;13(2):261-276. doi:10.1093/schbul/13.2.261
Leucht S, Kane JM, Kissling W, et al. What does the PANSS mean? Schizophr Res. 2005;79(2-3):231-238.
}
\examples{

# Example 1: Moderate Severity
# P-scale (all 4s), N-scale (all 3s), G-scale (all 2s)
p_vec <- rep(4, 7)
n_vec <- rep(3, 7)
g_vec <- rep(2, 16)
# Total = 28 + 21 + 32 = 81
panss_score(p_vec, n_vec, g_vec)

# Example 2: Minimum Score (Absent symptoms)
p_min <- rep(1, 7)
n_min <- rep(1, 7)
g_min <- rep(1, 16)
# Total = 30
panss_score(p_min, n_min, g_min)
}
