\name{osiris_osteoporosis_score}
\alias{osiris_osteoporosis_score}
\title{
Osteoporosis Index of Risk (OSIRIS)
}
\description{
Calculates the OSIRIS score to stratify the risk of osteoporosis in postmenopausal women. The score utilizes four simple clinical variables: age, body weight, current hormone replacement therapy (HRT) use, and history of prior low-impact fracture. It aids in selecting women for Bone Mineral Density (BMD) testing.
}
\usage{
osiris_osteoporosis_score(age, weight_kg, history_fracture, estrogen_therapy)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{history_fracture}{
Numeric (0 or 1). History of previous low-impact fracture (e.g., wrist, spine, hip) occurring after age 45. (1 = Yes, -2 points).
}
  \item{estrogen_therapy}{
Numeric (0 or 1). Current use of Estrogen Replacement Therapy / Hormone Replacement Therapy (HRT). (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{OSIRIS_Score}{The calculated index score.}
\item{Risk_Category}{Classification (High Risk < 1, Medium Risk 1-3, Low Risk > 3).}
\item{Recommendation}{Guidance regarding BMD testing.}
}
\references{
Sedrani O, et al. Accelerating the diagnosis of osteoporosis. The OSIRIS rule. (Osteoporosis Index of Risk). 2002.
}
\examples{

# Example 1: High Risk
# 75yo, 50kg, Prior Fracture (+2 negative points), No HRT
# Base = (50-75)*0.2 = -5. Fx = -2. Total = -7.
osiris_osteoporosis_score(75, 50, 1, 0)

# Example 2: Low Risk
# 55yo, 70kg, No Fracture, On HRT (+2 positive points)
# Base = (70-55)*0.2 = 3. HRT = +2. Total = 5.
osiris_osteoporosis_score(55, 70, 0, 1)
}
