\name{neck_disability_index}
\alias{neck_disability_index}
\title{
Neck Disability Index (NDI)
}
\description{
Calculates the Neck Disability Index (NDI), a standard instrument for measuring self-rated disability due to neck pain. It consists of 10 items related to daily activities, each scored from 0 to 5. The final score provides a percentage of disability.
}
\usage{
neck_disability_index(pain_intensity, personal_care, lifting, reading,
                      headaches, concentration, work, driving, sleeping,
                      recreation)
}
\arguments{
  \item{pain_intensity}{
Numeric (0-5). 0: No pain; 5: Worst imaginable pain.
}
  \item{personal_care}{
Numeric (0-5). 0: Can look after self normally; 5: Needs help with all personal care.
}
  \item{lifting}{
Numeric (0-5). 0: Can lift heavy weights; 5: Cannot lift or carry anything.
}
  \item{reading}{
Numeric (0-5). 0: Can read as much as wanted; 5: Cannot read at all.
}
  \item{headaches}{
Numeric (0-5). 0: No headaches; 5: Frequent/severe headaches almost all the time.
}
  \item{concentration}{
Numeric (0-5). 0: Can concentrate fully; 5: Cannot concentrate at all.
}
  \item{work}{
Numeric (0-5). 0: Can do as much work as wanted; 5: Cannot do any work.
}
  \item{driving}{
Numeric (0-5). 0: Can drive as long as wanted; 5: Cannot drive at all.
}
  \item{sleeping}{
Numeric (0-5). 0: No trouble sleeping; 5: Sleep is completely disturbed (1-2 hours).
}
  \item{recreation}{
Numeric (0-5). 0: Able to engage in all activities; 5: Cannot do any recreational activities.
}
}
\value{
A list containing:
\item{NDI_Score_Raw}{The sum of the section scores (Range 0-50).}
\item{NDI_Percentage}{The raw score converted to a percentage (Score * 2).}
\item{Interpretation}{Clinical severity of disability (None, Mild, Moderate, Severe, Complete).}
}
\references{
Vernon H, Mior S. The Neck Disability Index: a study of reliability and validity. J Manipulative Physiol Ther. 1991;14(7):409-415.
}
\examples{

# Example 1: Severe Disability
# Moderate to high scores across all domains
neck_disability_index(3, 2, 4, 3, 3, 2, 4, 3, 2, 3)

# Example 2: Mild Disability
# Minor pain and headache, mostly normal function
neck_disability_index(1, 0, 1, 0, 1, 0, 0, 0, 1, 0)
}
