\name{decaf_score_copd}
\alias{decaf_score_copd}
\title{
DECAF Score for Acute Exacerbation of COPD
}
\description{
Calculates the DECAF score to predict in-hospital mortality in patients hospitalized with an acute exacerbation of COPD. The score is based on Dyspnea (eMRCD), Eosinopenia, Consolidation, Acidemia, and Atrial Fibrillation.
}
\usage{
decaf_score_copd(emrcd_5a_5b, eosinophils, consolidation, ph_value,
                 atrial_fibrillation)
}
\arguments{
  \item{emrcd_5a_5b}{
Numeric (0 or 1). Extended MRC Dyspnea Score 5a (too breathless to leave house) or 5b (breathless dressing/undressing). (1 = Yes, +1 point).
}
  \item{eosinophils}{
Numeric. Eosinophil count in x10^9/L. (< 0.05 adds +1 point).
}
  \item{consolidation}{
Numeric (0 or 1). Consolidation present on Chest X-ray. (1 = Yes, +1 point).
}
  \item{ph_value}{
Numeric. Arterial or Venous pH. (< 7.30 adds +1 point).
}
  \item{atrial_fibrillation}{
Numeric (0 or 1). Atrial Fibrillation present on admission ECG or history. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{DECAF_Score}{The calculated score (Range 0-5).}
\item{Risk_Group}{Classification (Low 0-1, Intermediate 2, High 3-5).}
\item{In_Hospital_Mortality}{Estimated in-hospital mortality rate.}
}
\references{
Steer J, Gibson J, Bourke SC. The DECAF Score: predicting hospital mortality in exacerbations of chronic obstructive pulmonary disease. Thorax. 2012;67(11):970-976. doi:10.1136/thoraxjnl-2012-202103
}
\examples{

# Example 1: High Risk
# eMRCD 5b (1), Eos 0.02 (1), Consolidation (1), pH 7.35 (0), AFib (0)
# Score = 3
decaf_score_copd(1, 0.02, 1, 7.35, 0)

# Example 2: Low Risk
# eMRCD 4 (0), Eos 0.2 (0), No consolidation (0), pH 7.4 (0), No AFib (0)
# Score = 0
decaf_score_copd(0, 0.2, 0, 7.4, 0)
}
