\name{cci_platelet_transfusion}
\alias{cci_platelet_transfusion}
\title{
Corrected Count Increment (CCI) for Platelet Transfusion
}
\description{
Calculates the Corrected Count Increment (CCI) to evaluate the efficacy of platelet transfusions. This metric adjusts the observed rise in platelet count for the patient's body surface area and the dose of platelets administered. It is the standard method for diagnosing platelet refractoriness.
}
\usage{
cci_platelet_transfusion(post_platelet_count, pre_platelet_count, bsa,
                         platelets_transfused_10_11)
}
\arguments{
  \item{post_platelet_count}{
Numeric. Platelet count measured 10-60 minutes after transfusion (cells/uL or /mm3).
}
  \item{pre_platelet_count}{
Numeric. Platelet count measured prior to transfusion (cells/uL or /mm3).
}
  \item{bsa}{
Numeric. Patient's Body Surface Area in m^2.
}
  \item{platelets_transfused_10_11}{
Numeric. The number of platelets transfused in units of 10^11. (e.g., for 3.0 x 10^11 platelets, enter 3.0). A typical apheresis unit contains ~3.0-4.0 x 10^11 platelets. A pooled random donor unit contains ~0.5-0.8 x 10^11 per unit.
}
}
\value{
A list containing:
\item{CCI_Value}{The calculated Corrected Count Increment.}
\item{Interpretation}{Clinical interpretation regarding refractoriness (typically defined as CCI < 7500 at 1 hour).}
}
\references{
Hod E, Schwartz J. Platelet transfusion refractoriness. Br J Haematol. 2008;142(3):348-360. doi:10.1111/j.1365-2141.2008.07189.x
}
\examples{

# Example 1: Successful Transfusion
# Post 40k, Pre 10k, BSA 1.8, Transfused 3.0 x 10^11
# CCI = ((40000 - 10000) * 1.8) / 3.0 = 18000
cci_platelet_transfusion(40000, 10000, 1.8, 3.0)

# Example 2: Refractory
# Post 12k, Pre 10k, BSA 2.0, Transfused 3.0 x 10^11
# CCI = ((12000 - 10000) * 2.0) / 3.0 = 1333
cci_platelet_transfusion(12000, 10000, 2.0, 3.0)
}
