\name{calculate_ttkg}
\alias{calculate_ttkg}
\title{
Transtubular Potassium Gradient (TTKG)
}
\description{
Calculates the Transtubular Potassium Gradient (TTKG), a semi-quantitative index of the potassium secretory process in the cortical collecting duct. It is used to distinguish between renal and extra-renal causes of potassium imbalance (hypokalemia or hyperkalemia). The calculation requires urine osmolality to be greater than serum osmolality to be valid.
}
\usage{
calculate_ttkg(urine_potassium, serum_potassium, urine_osmolality, serum_osmolality)
}
\arguments{
  \item{urine_potassium}{
Numeric. Urine potassium concentration in mmol/L (or mEq/L).
}
  \item{serum_potassium}{
Numeric. Serum potassium concentration in mmol/L (or mEq/L).
}
  \item{urine_osmolality}{
Numeric. Urine osmolality in mOsm/kg.
}
  \item{serum_osmolality}{
Numeric. Serum osmolality in mOsm/kg.
}
}
\details{
The formula is:
\deqn{TTKG = \frac{Urine_{K} \times Serum_{Osm}}{Serum_{K} \times Urine_{Osm}}}
**Validity condition:** The formula assumes that water is reabsorbed in the medullary collecting duct, which requires \eqn{Urine_{Osm} > Serum_{Osm}}. If this condition is not met, the result is physiologically invalid.
}
\value{
A list containing:
\item{TTKG_Score}{The calculated gradient value.}
\item{Validity}{Status indicating if the osmotic condition for calculation was met.}
\item{Interpretation}{Clinical context based on standard thresholds (<3 or >7).}
}
\references{
Ethier JH, Kamel KS, Magner PO, Lemann J Jr, Halperin ML. The transtubular potassium concentration in patients with hypokalemia and hyperkalemia. Am J Kidney Dis. 1990;15(4):309-315. doi:10.1016/s0272-6386(12)80076-x
}
\examples{

# Example 1: Renal K+ Wasting (Hyperaldosteronism context)
# Urine K 40, Serum K 3.0, Urine Osm 600, Serum Osm 290
# TTKG = (40 * 290) / (3.0 * 600) = 11600 / 1800 = 6.44
calculate_ttkg(40, 3.0, 600, 290)

# Example 2: Invalid Calculation (Dilute Urine)
# Urine Osm < Serum Osm
calculate_ttkg(10, 4.0, 200, 290)
}
