\name{berg_balance_scale}
\alias{berg_balance_scale}
\title{
Berg Balance Scale (BBS)
}
\description{
Calculates the Berg Balance Scale score, a widely used clinical test of a person's static and dynamic balance abilities. The scale consists of 14 functional tasks, each scored from 0 to 4. The total score (0-56) indicates the patient's risk of falling.
}
\usage{
berg_balance_scale(sit_to_stand, standing_unsupported, sitting_unsupported,
                   stand_to_sit, transfers, standing_eyes_closed,
                   standing_feet_together, reaching_forward, retrieving_object,
                   turning_to_look_behind, turning_360, stool_stepping,
                   tandem_standing, one_leg_stand)
}
\arguments{
  \item{sit_to_stand}{
Numeric (0-4). Ability to stand up.
}
  \item{standing_unsupported}{
Numeric (0-4). Ability to stand for 2 minutes without holding on.
}
  \item{sitting_unsupported}{
Numeric (0-4). Ability to sit with back unsupported but feet on floor or on a stool.
}
  \item{stand_to_sit}{
Numeric (0-4). Ability to sit down.
}
  \item{transfers}{
Numeric (0-4). Ability to transfer (e.g., bed to chair).
}
  \item{standing_eyes_closed}{
Numeric (0-4). Ability to stand unsupported with eyes closed.
}
  \item{standing_feet_together}{
Numeric (0-4). Ability to stand unsupported with feet together.
}
  \item{reaching_forward}{
Numeric (0-4). Ability to reach forward with outstretched arm while standing.
}
  \item{retrieving_object}{
Numeric (0-4). Ability to pick up an object from the floor from a standing position.
}
  \item{turning_to_look_behind}{
Numeric (0-4). Ability to turn to look behind over left and right shoulders while standing.
}
  \item{turning_360}{
Numeric (0-4). Ability to turn 360 degrees.
}
  \item{stool_stepping}{
Numeric (0-4). Ability to place alternate foot on a step or stool while standing unsupported.
}
  \item{tandem_standing}{
Numeric (0-4). Ability to stand with one foot in front of the other.
}
  \item{one_leg_stand}{
Numeric (0-4). Ability to stand on one leg.
}
}
\value{
A list containing:
\item{BBS_Total_Score}{The sum of the 14 items (Range 0-56).}
\item{Fall_Risk_Classification}{Interpretation: "High Fall Risk" (0-20), "Medium Fall Risk" (21-40), or "Low Fall Risk" (41-56).}
}
\references{
Berg KO, Wood-Dauphinee SL, Williams JI, Maki B. Measuring balance in the elderly: validation of an instrument. Can J Public Health. 1992;83 Suppl 2:S7-11.
}
\examples{

# Example 1: Low Fall Risk
# Most items scored 4 or 3
berg_balance_scale(4, 4, 4, 4, 4, 4, 4, 3, 3, 4, 3, 4, 2, 2)

# Example 2: High Fall Risk
# Most items scored 0 or 1
berg_balance_scale(1, 1, 2, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0)
}
