\name{ada_diabetes_risk}
\alias{ada_diabetes_risk}
\title{
American Diabetes Association (ADA) Risk Calculator
}
\description{
Calculates the risk score for Type 2 Diabetes using the American Diabetes Association (ADA) Risk Test. This tool evaluates risk factors including age, sex, family history, hypertension, physical activity, and BMI to determine if a patient is at high risk and should be screened for diabetes.
}
\usage{
ada_diabetes_risk(age, sex, family_history, high_bp, physically_active,
                  height_in, weight_lbs, history_gestational_dm = 0)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
< 40: 0 points.
40-49: 1 point.
50-59: 2 points.
>= 60: 3 points.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
Male: +1 point.
Female: 0 points.
}
  \item{family_history}{
Numeric (0 or 1). Do you have a mother, father, sister, or brother with diabetes? (1 = Yes, +1 point).
}
  \item{high_bp}{
Numeric (0 or 1). Have you ever been diagnosed with high blood pressure? (1 = Yes, +1 point).
}
  \item{physically_active}{
Numeric (0 or 1). Are you physically active? (1 = Yes, 0 points; 0 = No, +1 point).
}
  \item{height_in}{
Numeric. Patient height in inches.
}
  \item{weight_lbs}{
Numeric. Patient weight in pounds. (Used to calculate BMI).
BMI < 25: 0 points.
BMI 25-29.9: +1 point.
BMI 30-39.9: +2 points.
BMI >= 40: +3 points.
}
  \item{history_gestational_dm}{
Numeric (0 or 1). For women: Have you ever been diagnosed with gestational diabetes? (1 = Yes, +1 point). Defaults to 0.
}
}
\value{
A list containing:
\item{Total_Score}{The calculated ADA risk score (Range 0-11).}
\item{Risk_Category}{"High Risk" (Score >= 5) or "Low Risk" (Score < 5).}
\item{Recommendation}{Guidance on whether to seek clinical testing.}
\item{Calculated_BMI}{The BMI derived from the height and weight inputs.}
}
\references{
Bang H, Edwards AM, Bomback AS, et al. Development and validation of a patient self-assessment score for diabetes risk. Ann Intern Med. 2009;151(11):775-783. doi:10.7326/0003-4819-151-11-200912010-00005
}
\examples{

# Example 1: High Risk
# 55yo Male, Family Hx, High BP, Inactive, Overweight (BMI ~27)
# Age(2) + Sex(1) + Fam(1) + BP(1) + Inactive(1) + BMI(1) = 7
ada_diabetes_risk(55, "male", 1, 1, 0, 70, 190, 0)

# Example 2: Low Risk
# 35yo Female, Active, Normal Weight, No other factors
# Age(0) + Sex(0) + Fam(0) + BP(0) + Active(0) + BMI(0) = 0
ada_diabetes_risk(35, "female", 0, 0, 1, 65, 130, 0)
}
