% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicalomicsdbR.R
\name{clinicalomicsdbR}
\alias{clinicalomicsdbR}
\title{clinicalomicsdbR object}
\value{
Returns a new clinicalomicsdbR object
}
\description{
clinicalomicsdbR object

clinicalomicsdbR object
}
\examples{
clinicalomicsdbR$new()$filter(drugs = c("ipilimumab", "rituximab"))$study_list # downloads all files
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hostname}}{The url of the API to connect to. Only change if you are using a custom service.}

\item{\code{study_list}}{The list of all the studies that are a result of filtering.}

\item{\code{verbosity}}{The level of messages wanted for downloads (defaults to 0: No Output). Follows httr2 documentatation for \code{req_perform}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-clinicalomicsdbR-filter}{\code{clinicalomicsdbR$filter()}}
\item \href{#method-clinicalomicsdbR-get_download_url}{\code{clinicalomicsdbR$get_download_url()}}
\item \href{#method-clinicalomicsdbR-download}{\code{clinicalomicsdbR$download()}}
\item \href{#method-clinicalomicsdbR-download_from_id}{\code{clinicalomicsdbR$download_from_id()}}
\item \href{#method-clinicalomicsdbR-dataframe}{\code{clinicalomicsdbR$dataframe()}}
\item \href{#method-clinicalomicsdbR-dataframe_from_id}{\code{clinicalomicsdbR$dataframe_from_id()}}
\item \href{#method-clinicalomicsdbR-clone}{\code{clinicalomicsdbR$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-filter"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-filter}{}}}
\subsection{Method \code{filter()}}{
filter objects according to the specified drugs and cancers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$filter(drugs = c(), cancers = c())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drugs}}{list or vector containing drugs that studies need to contain at least one of}

\item{\code{cancers}}{list of vector of cancer types to consider. Leave empty to consider all cancer types}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
new clinicalomicsdbR object with the filtered results in \verb{$study_list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-get_download_url"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-get_download_url}{}}}
\subsection{Method \code{get_download_url()}}{
Get download url for a study at specified \code{study_id}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$get_download_url(study_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{study_id}}{String of the ID of the study to get the download url of}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
String of the download url
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-download"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-download}{}}}
\subsection{Method \code{download()}}{
Download all files of the studies in \code{self$study_list}. Use \code{filter} function first
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$download(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{Directory to download files to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
unmodifed clinicalomicsdbR object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-download_from_id"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-download_from_id}{}}}
\subsection{Method \code{download_from_id()}}{
Download all file from \code{study_id} into \code{output_dir} directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$download_from_id(study_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{study_id}}{String containing the ID of the study to download}

\item{\code{output_dir}}{Directory to download files to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
unmodifed clinicalomicsdbR object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-dataframe"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-dataframe}{}}}
\subsection{Method \code{dataframe()}}{
Get all files of the studies in \code{self$study_list} and load into data frame. Use \code{filter} function first.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$dataframe()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list with \code{study_list} element to display all studies and list \code{df} with each dataframe in the list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-dataframe_from_id"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-dataframe_from_id}{}}}
\subsection{Method \code{dataframe_from_id()}}{
Get file from \code{study_id} and convert into dataframe.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$dataframe_from_id(study_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{study_id}}{String containing the ID of the study to get dataframe of}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data frame containing data of study
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clinicalomicsdbR-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clinicalomicsdbR-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{clinicalomicsdbR$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
