% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_albumin_unit.R
\name{convert_albumin_unit}
\alias{convert_albumin_unit}
\title{Convert albumin from / to units}
\usage{
convert_albumin_unit(
  value,
  unit_in = valid_units("serum_albumin"),
  unit_out = valid_units("serum_albumin")
)
}
\arguments{
\item{value}{albumin measurements}

\item{unit_in}{from unit, e.g. `"g_l"`.}

\item{unit_out}{to flow unit, e.g. `"g_dl"`}
}
\description{
Accepted units are "g_l", "g_dl", or "micromol_l". Arguments supplied to `value` and
`unit_in` units must be of the same length. "To" unit must be of length 1.
#'
}
\examples{

## single values
convert_albumin_unit(0.6, "g_dl", "g_l")

## vectorized
convert_albumin_unit(
  c(0.4, 2, 0.3), 
  unit_in = c("g_dl", "g_l", "g_dl"),
  unit_out = c("g_l")
)
  
}
