% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviationThroughTime.R
\name{deviationThroughTime}
\alias{deviationThroughTime}
\title{Calculating deviation through time}
\usage{
deviationThroughTime(variableDirectory, timeSlicePeriod, fileExtension = "asc")
}
\arguments{
\item{variableDirectory}{A directory containing at least two time slice rasters for a given climate variable.}

\item{timeSlicePeriod}{Either a single number, in years, representing the time period elapsed between temporally-even
climate variable raster slices, or a vector corresponding to periods, in years, between temporally-uneven time slices.}

\item{fileExtension}{a character that describes a fileExtension corresponding to one of the suported drivers in
\code{\link[terra]{gdal}}}
}
\value{
A raster showing the geographic distribution of climate deviation through time for a particular climate variable.
}
\description{
A function that reads time-slice rasters of data for a given climate (typically processed data from a
climate model run, such as the results of an analysis using PaleoView (Fordham, *et al.* 2017, Ecography)) in a given
directory and calculates average deviation per year across time slices.
}
\details{
Make sure that files in the `variableDirectory` are read into `R` in order.

If you are specifying temporally-uneven time slices with `timeSlicePeriod`, make sure that each number corresponds to the
number of years elapsed *between* time slices, *in the same order as the files were read into `R`*. There should be one
less number than the number of files, and you must have at least three files in the directory.

See `precipDeviation.asc` and `temperatureDeviation.asc` for examples of rasters created using this function. See reference
for data source details.
}
\examples{
# Generate sample data
td <- tempdir()
suppressWarnings(x <- terra::rast(nrows=20, ncols=20,
                                  xmin=0, xmax=10, ymin=0, ymax=10,
                                  vals = c(10,10,10,10,20)))
x2 <- x * 1.01
rastStack <- c(x, x2, x)
terra::writeRaster(rastStack, filename = paste0(td, "/raster",
                                                1:terra::nlyr(rastStack), ".tif"),
                   overwrite = TRUE)

# Even time slices
testResult <- deviationThroughTime(td, timeSlicePeriod = 100,
                                   fileExtension = "tif")

# Uneven time slices
testResult <- deviationThroughTime(variableDirectory = td,
                                   timeSlicePeriod = c(25, 100),
                                   fileExtension = "tif")
# Delete temporary files
unlink(td)

}
\references{
Owens, H.L., Guralnick, R., 2019. climateStability: An R package to estimate
climate stability from time-slice climatologies. Biodiversity Informatics
14, 8–13. https://doi.org/10.17161/bi.v14i0.9786
}
\keyword{manip}
