% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate_world}
\alias{climate_world}
\alias{world_climate}
\title{Climate data in the world}
\format{
A data frame with 41328 (3444 stations * 12 months) rows
and 12 variable:
\describe{
\item{no           }{Station no}
\item{continent    }{Continent. Escaped by stringi::stri_escape_unicode().}
\item{country      }{Country name. Escaped by stringi::stri_escape_unicode().}
\item{station      }{Station name. To avoid duplication, including country name after station name. Can split by "_". Escaped by stringi::stri_escape_unicode().}
\item{month        }{Month}
\item{temperature  }{Mean temperature}
\item{precipitation}{Mean precipitation}
\item{latitude     }{Latitude. (degree)}
\item{NS           }{North or South.}
\item{longitude    }{Longitude. (degree)}
\item{WE           }{West or East.}
\item{altitude     }{Altitude (m)}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 41328 rows and 12 columns.
}
\usage{
climate_world

world_climate
}
\description{
Climate data downloaded from Japan Meteorological Agency web pages.
URLs of each station are listed in data(station_links).
https://www.data.jma.go.jp/gmd/cpd/monitor/nrmlist/
}
\examples{
library(magrittr)
library(stringi)
library(dplyr)
data(world_climate)
world_climate \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode)
}
\keyword{datasets}
