% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_pairs.R
\name{f_measure_pairs}
\alias{f_measure_pairs}
\title{F-measure of Linked Pairs}
\usage{
f_measure_pairs(true_pairs, pred_pairs, beta = 1, ordered = FALSE)
}
\arguments{
\item{true_pairs}{set of true coreferent pairs stored in a matrix or
data.frame, where rows index pairs and columns index the ids of the
constituents. Any pairs not included are assumed to be \emph{non-coreferent}.
Duplicate pairs (including equivalent pairs with reversed ids) are
automatically removed.}

\item{pred_pairs}{set of predicted coreferent pairs, following the same
specification as \code{true_pairs}.}

\item{beta}{non-negative weight. A value of 0 assigns no weight to recall
(i.e. the measure reduces to precision), while larger values assign
increasing weight to recall. A value of 1 weights precision and recall
equally.}

\item{ordered}{whether to treat the element pairs as ordered---i.e. whether
pair \eqn{(x, y)} is distinct from pair \eqn{(y, x)} for \eqn{x \neq y}.
Defaults to FALSE, which is appropriate for clustering, undirected link
prediction, record linkage etc.}
}
\description{
Computes the F-measure (a.k.a. F-score) of a set of
\emph{predicted} coreferent (linked) pairs given a set of \emph{ground truth}
coreferent pairs.
}
\details{
The \eqn{\beta}{β}-weighted F-measure is defined as the weighted
harmonic mean of precision \eqn{P} and recall \eqn{R}:
\deqn{(1 + \beta^2)\frac{P \cdot R}{\beta^2 \cdot P + R}.}{(1 + β^2)·P·R/(β^2·P + R).}
}
\examples{
true_pairs <- rbind(c(1,2), c(2,3), c(1,3)) # ground truth is 3-clique
pred_pairs <- rbind(c(1,2), c(2,3))         # prediction misses one edge
num_pairs <- 3                              # assuming 3 elements
f_measure_pairs(true_pairs, pred_pairs, num_pairs)

}
\references{
Van Rijsbergen, C. J. "Information Retrieval." (2nd ed.).
Butterworth-Heinemann, USA, (1979).
}
