% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{eval_report_clusters}
\alias{eval_report_clusters}
\title{Evaluation Report for Clustering}
\usage{
eval_report_clusters(true, pred)
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}
}
\value{
Returns a list containing the following measures:
\describe{
\item{homogeneity}{see \code{\link{homogeneity}}}
\item{completeness}{see \code{\link{completeness}}}
\item{v_measure}{see \code{\link{v_measure}}}
\item{rand_index}{see \code{\link{rand_index}}}
\item{adj_rand_index}{see \code{\link{adj_rand_index}}}
\item{variation_info}{see \code{\link{variation_info}}}
\item{mutual_info}{see \code{\link{mutual_info}}}
\item{fowlkes_mallows}{see \code{\link{fowlkes_mallows}}}
}
}
\description{
Compute various evaluation measures for a predicted
clustering using a ground truth clustering as a reference.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
eval_report_clusters(true, pred)

}
