% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{clusters_to_membership}
\alias{clusters_to_membership}
\alias{membership_to_clusters}
\alias{clusters_to_pairs}
\alias{membership_to_pairs}
\alias{pairs_to_membership}
\alias{pairs_to_clusters}
\title{Transform Clustering Representations}
\usage{
clusters_to_membership(clusters, elem_ids = NULL, clust_ids = NULL)

membership_to_clusters(membership, elem_ids = NULL, clust_ids = NULL)

clusters_to_pairs(clusters)

membership_to_pairs(membership, elem_ids = NULL)

pairs_to_membership(pairs, elem_ids)

pairs_to_clusters(pairs, elem_ids)
}
\arguments{
\item{clusters}{a representation of a clustering as a list of vectors,
where the i-th vector contains the identifiers of elements assigned to the
i-th cluster. If \code{clust_ids} is specified (see below), the i-th cluster
is identified according to the corresponding entry in \code{clust_ids}.
Otherwise the i-th cluster is identified according it's name (if
\code{clusters} is a named list) or its integer index i.}

\item{elem_ids}{a vector specifying the complete set of identifiers for the
cluster elements in canonical order. Optional for all functions excluding
\code{pairs_to_membership} and \code{pairs_to_clusters}.}

\item{clust_ids}{a vector specifying the complete set of identifiers for
the clusters in canonical order. Optional for all functions.}

\item{membership}{a representation of a clustering as a membership vector,
where the i-th entry contains the cluster identifier for the i-th element.
If \code{elem_ids} is specified (see below), the i-th element is identified
according to the corresponding entry in \code{elem_ids}. Otherwise the i-th
element is identified according it's name (if \code{members} is a named vector)
or its integer index i.}

\item{pairs}{a representation of a clustering as a matrix or data.frame
containing all pairs of elements that are co-clustered. The rows index
of the matrix/data.frame index pairs and columns index the identifiers
of the constituent elements. The \code{elem_ids} argument (see below) must be
specified in order to recover singleton clusters (containing a single
element).}
}
\value{
\code{clusters_to_membership} and \code{pairs_to_membership} both return a
membership vector representation of the clustering. The order of the
elements is taken from \code{elem_ids} if specified, otherwise the elements are
ordered lexicographically by their identifiers. For
\code{pairs_to_membership}, the cluster identifiers cannot be recovered and
are taken to be integers.

\code{membership_to_clusters} and \code{pairs_to_clusters} both return a
representation of the clustering as a list of vectors. The order of the
clusters is taken from \code{clust_ids} if specified, otherwise the clusters
are ordered lexicographically by their identifiers. For
\code{pairs_to_clusters}, the cluster identifiers cannot be recovered and
are taken to be integers.

\code{clusters_to_pairs} and \code{membership_to_pairs} both return a
representation of the clustering as a matrix of element pairs that are
co-clustered. This representation results in loss of information, as
singleton clusters (with one element) and cluster identifiers are not
represented.
}
\description{
Transform between different representations of a clustering.
}
\examples{
## A clustering of three items represented as a membership vector
m <- c("Item1" = 1, "Item2" = 2, "Item3" = 1)

# Transform to list of clusters
membership_to_clusters(m)
# Specify different identifiers for the items
membership_to_clusters(m, elem_ids = c(1, 2, 3))
# Transform to array of pairs that are co-clustered
membership_to_pairs(m)

## A clustering represented as a list of clusters
cl <- list("ClustA" = c(1,3), "ClustB" = c(2))

# Transform to membership vector representation
clusters_to_membership(cl)
# Transform to array of pairs that are co-clustered
clusters_to_pairs(cl)

## A clustering (incompletely) represented as an array of pairs that
## are co-clustered
p <- rbind(c(1,3)) # pairs of elements in the same cluster
ids <- c(1,2,3)    # necessary to specify set of all elements

# Transform to membership vector representation
pairs_to_membership(p, ids)
# Transform to list of clusters
pairs_to_clusters(p, ids)

}
